/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.jda;

import com.ebicep.jda.BotListener;
import com.ebicep.jda.queuesystem.QueueListener;
import com.ebicep.jda.queuesystem.QueueManager;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.debugcommands.misc.ServerStatusCommand;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import com.ebicep.warlords.game.state.PlayingState;
import com.ebicep.warlords.game.state.PreLobbyState;
import com.ebicep.warlords.util.warlords.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BotManager {
    public static JDA jda;
    public static String botToken;
    public static Guild compGamesServer;
    public static String compGamesServerID;
    public static String compGamesServerStatusChannel;
    public static HashMap<String, TextChannel> compGamesServerChannelCache;
    public static Message compStatusMessage;
    public static Guild wl2Server;
    public static String wl2ServerID;
    public static String wl2ServerStatusChannel;
    public static HashMap<String, TextChannel> wl2ServerChannelCache;
    public static Message wl2StatusMessage;
    public static BukkitTask task;
    public static int numberOfMessagesSentLast30Sec;

    public static void connect() throws LoginException {
        if (botToken != null) {
            jda = JDABuilder.createDefault(botToken).enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[0]).addEventListeners(new BotListener(), new QueueListener()).build();
            task = new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    if (jda.getStatus() != JDA.Status.CONNECTED) {
                        return;
                    }
                    if (!Warlords.onCustomServer()) {
                        if (this.counter == 0) {
                            BotManager.getTextChannelCompsByName("waiting").ifPresent(textChannel -> ((CompletableFuture)textChannel.getIterableHistory().takeAsync(1000).thenAccept(textChannel::purgeMessages)).thenAccept(unused -> QueueManager.sendQueue()));
                        }
                        if (this.counter % 10 == 0 && QueueManager.sendQueue) {
                            QueueManager.sendQueue = false;
                            QueueManager.sendNewQueue();
                        }
                        if (this.counter % 30 == 0 && ServerStatusCommand.enabled) {
                            BotManager.sendStatusMessage(false);
                        }
                    }
                    if (this.counter % 3 == 0 && numberOfMessagesSentLast30Sec > 0) {
                        --numberOfMessagesSentLast30Sec;
                    }
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)Warlords.getInstance(), 100L, 20L);
        }
    }

    public static void sendDebugMessage(String message) {
        if (jda == null) {
            return;
        }
        BotManager.getWL2Server().getTextChannels().stream().filter(textChannel -> textChannel.getName().equalsIgnoreCase("admin-log")).findFirst().ifPresent(textChannel -> textChannel.sendMessage(message).queue());
    }

    public static void sendDebugMessage(MessageEmbed embed) {
        if (jda == null) {
            return;
        }
        BotManager.getWL2Server().getTextChannels().stream().filter(textChannel -> textChannel.getName().equalsIgnoreCase("admin-log")).findFirst().ifPresent(textChannel -> textChannel.sendMessageEmbeds(embed, new MessageEmbed[0]).queue());
    }

    public static Guild getCompGamesServer() {
        if (compGamesServer != null) {
            return compGamesServer;
        }
        compGamesServer = jda.getGuildById(compGamesServerID);
        return compGamesServer;
    }

    public static Guild getWL2Server() {
        if (wl2Server != null) {
            return wl2Server;
        }
        wl2Server = jda.getGuildById(wl2ServerID);
        return wl2Server;
    }

    public static Optional<TextChannel> getTextChannelCompsByName(String name) {
        if (compGamesServerChannelCache.containsKey(name)) {
            return Optional.ofNullable(compGamesServerChannelCache.get(name));
        }
        Optional<TextChannel> optionalTextChannel = BotManager.getCompGamesServer().getTextChannels().stream().filter(textChannel -> textChannel.getName().equalsIgnoreCase(name)).findFirst();
        optionalTextChannel.ifPresent(textChannel -> compGamesServerChannelCache.put(name, (TextChannel)textChannel));
        return optionalTextChannel;
    }

    public static Optional<TextChannel> getTextChannelWL2ByName(String name) {
        if (wl2ServerChannelCache.containsKey(name)) {
            return Optional.ofNullable(wl2ServerChannelCache.get(name));
        }
        Optional<TextChannel> optionalTextChannel = BotManager.getWL2Server().getTextChannels().stream().filter(textChannel -> textChannel.getName().equalsIgnoreCase(name)).findFirst();
        optionalTextChannel.ifPresent(textChannel -> wl2ServerChannelCache.put(name, (TextChannel)textChannel));
        return optionalTextChannel;
    }

    public static void sendMessageToNotificationChannel(String message, boolean sendToCompServer, boolean sendToWL2Server) {
        if (jda == null) {
            return;
        }
        if (numberOfMessagesSentLast30Sec > 15) {
            return;
        }
        if (Warlords.onCustomServer()) {
            return;
        }
        if (sendToCompServer) {
            BotManager.getTextChannelCompsByName(compGamesServerStatusChannel).ifPresent(textChannel -> textChannel.sendMessage(message).queue());
        }
        if (sendToWL2Server) {
            BotManager.getTextChannelWL2ByName(wl2ServerStatusChannel).ifPresent(textChannel -> textChannel.sendMessage(message).queue());
        }
    }

    public static void sendStatusMessage(boolean onQuit) {
        if (Warlords.onCustomServer()) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aa");
        dateFormat.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        EmbedBuilder eb = new EmbedBuilder().setTitle("Server Status", null).setColor(3066993).setTimestamp(new Date().toInstant());
        eb.setDescription("**Players Online**: " + (onQuit ? Bukkit.getOnlinePlayers().size() - 1 : Bukkit.getOnlinePlayers().size()) + "\n");
        eb.appendDescription("**Players In Game**: " + Warlords.getGameManager().getPlayerCount() + "\n");
        eb.appendDescription("**Players Waiting in lobby**: " + Warlords.getGameManager().getPlayerCountInLobby() + "\n");
        for (GameManager.GameHolder holder : Warlords.getGameManager().getGames()) {
            Game game = holder.getGame();
            if (game == null) continue;
            if (game.getState() instanceof PreLobbyState) {
                PreLobbyState state = (PreLobbyState)game.getState();
                if (!state.hasEnoughPlayers()) {
                    eb.appendDescription("**Game**: " + game.getMap().getMapName() + " Lobby - Waiting for players\n");
                    continue;
                }
                eb.appendDescription("**Game**: " + game.getMap().getMapName() + " Lobby - " + state.getTimeLeftString() + " Left\n");
                continue;
            }
            if (!(game.getState() instanceof PlayingState)) continue;
            OptionalInt timeLeft = WinAfterTimeoutOption.getTimeRemaining(game);
            String time = Utils.formatTimeLeft(timeLeft.isPresent() ? (long)timeLeft.getAsInt() : (System.currentTimeMillis() - game.createdAt()) / 1000L);
            String word = timeLeft.isPresent() ? " Left" : " Elapsed";
            eb.appendDescription("**Game**: " + game.getMap().getMapName() + " - " + time + word + " - " + game.getPoints(Team.BLUE) + ":" + game.getPoints(Team.RED) + "\n");
        }
        StringBuilder stringBuilder = new StringBuilder("**Parties**: ");
        Warlords.partyManager.getParties().forEach(party -> stringBuilder.append(party.getLeaderName()).append(" (").append(party.getPartyPlayers().size()).append("), "));
        stringBuilder.setLength(stringBuilder.length() - 1);
        eb.appendDescription(stringBuilder);
        MessageEmbed messageEmbed = eb.build();
        BotManager.getTextChannelCompsByName(compGamesServerStatusChannel).ifPresent(textChannel -> {
            try {
                textChannel.getLatestMessageId();
            }
            catch (Exception e) {
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    compStatusMessage = m4;
                });
                return;
            }
            if (compStatusMessage == null) {
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    compStatusMessage = m4;
                });
            } else if (textChannel.getLatestMessageId().equals(compStatusMessage.getId())) {
                compStatusMessage.editMessageEmbeds(messageEmbed).queue();
            } else {
                compStatusMessage.delete().queue();
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    compStatusMessage = m4;
                });
            }
        });
        BotManager.getTextChannelWL2ByName(wl2ServerStatusChannel).ifPresent(textChannel -> {
            try {
                textChannel.getLatestMessageId();
            }
            catch (Exception e) {
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    wl2StatusMessage = m4;
                });
                return;
            }
            if (wl2StatusMessage == null) {
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    wl2StatusMessage = m4;
                });
            } else if (textChannel.getLatestMessageId().equals(wl2StatusMessage.getId())) {
                wl2StatusMessage.editMessageEmbeds(messageEmbed).queue();
            } else {
                wl2StatusMessage.delete().queue();
                textChannel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue(m4 -> {
                    wl2StatusMessage = m4;
                });
            }
        });
    }

    public static void deleteStatusMessage() {
        if (compStatusMessage != null) {
            compStatusMessage.delete().complete();
        }
        if (wl2StatusMessage != null) {
            wl2StatusMessage.delete().complete();
        }
    }

    static {
        compGamesServerID = "776590423501045760";
        compGamesServerStatusChannel = "instant-updates";
        compGamesServerChannelCache = new HashMap();
        wl2ServerID = "931564871462572062";
        wl2ServerStatusChannel = "server-status";
        wl2ServerChannelCache = new HashMap();
        numberOfMessagesSentLast30Sec = 0;
    }
}

