/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.jda;

import com.ebicep.jda.BotManager;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.miscellaneouscommands.DiscordCommand;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BotListener
extends ListenerAdapter
implements Listener {
    private static BukkitTask onGoingBalance;

    private static void cancelOnGoingBalance() {
        if (onGoingBalance != null) {
            onGoingBalance.cancel();
        }
    }

    @EventHandler
    public static void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (BotManager.getCompGamesServer() == null) {
            return;
        }
    }

    @EventHandler
    public static void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (BotManager.getCompGamesServer() == null) {
            return;
        }
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (Warlords.onCustomServer()) {
            return;
        }
        Member member = event.getMember();
        Message message = event.getMessage();
        if (event.isFromType(ChannelType.PRIVATE)) {
            if (event.getAuthor().isBot()) {
                return;
            }
            try {
                Long key = Long.parseLong(message.getContentRaw());
                if (DiscordCommand.playerLinkKeys.containsValue(key)) {
                    UUID uuid = DiscordCommand.playerLinkKeys.getKey(key);
                    if (DatabaseManager.playerService == null) {
                        return;
                    }
                    Warlords.newChain().asyncFirst(() -> DatabaseManager.playerService.findByUUID(uuid)).syncLast(databasePlayer -> {
                        Long id = event.getAuthor().getIdLong();
                        databasePlayer.setDiscordID(id);
                        DatabaseManager.updatePlayerAsync(databasePlayer);
                        event.getPrivateChannel().sendMessage("You linked **" + Bukkit.getOfflinePlayer((UUID)uuid).getName() + "** to your discord account (" + id + ").").queue();
                        if (Bukkit.getOfflinePlayer((UUID)uuid).isOnline()) {
                            Bukkit.getOfflinePlayer((UUID)uuid).getPlayer().sendMessage(ChatColor.GREEN + "Your account was linked to the discord account " + event.getAuthor().getAsTag() + " (" + id + ").");
                        }
                        BotManager.sendDebugMessage(new EmbedBuilder().setColor(3066993).setTitle("Player Linked - " + id).setDescription("UUID: " + uuid + "\nIGN: " + databasePlayer.getName() + "\nKEY: " + key).build());
                    }).execute();
                }
            }
            catch (Exception e) {
                System.out.println(message);
                System.out.println("Could not parseLong from direct message");
                e.printStackTrace();
            }
        } else if (event.isFromType(ChannelType.TEXT)) {
            TextChannel textChannel = event.getTextChannel();
            switch (textChannel.getName().toLowerCase()) {
                case "gs-teams": 
                case "bot-teams": {
                    if (message.getContentRaw().contains(", Balance Cancelled")) {
                        BotListener.cancelOnGoingBalance();
                        break;
                    }
                    if (message.getEmbeds().isEmpty() || message.getEmbeds().get(0).getFields().size() != 2) break;
                    BotListener.cancelOnGoingBalance();
                    MessageEmbed embed = message.getEmbeds().get(0);
                    final ArrayList<String> playerNames = new ArrayList<String>();
                    for (MessageEmbed.Field field : embed.getFields()) {
                        String fieldName = field.getName();
                        String fieldValue = field.getValue();
                        if (fieldName == null || fieldValue == null) continue;
                        String[] players = fieldValue.replace("```", "").replace(" ", "").split("\n");
                        if (!fieldName.contains("Blue Team") && !fieldName.contains("Red Team")) continue;
                        for (String player : players) {
                            playerNames.add(player.substring(0, player.indexOf(45)));
                        }
                    }
                    onGoingBalance = new BukkitRunnable(){
                        int counter = 0;

                        public void run() {
                            playerNames.forEach(name -> {
                                Player player = Bukkit.getPlayer((String)name);
                                if (player != null) {
                                    Random random = new Random();
                                    PacketUtils.sendTitle(player, ChatColor.GREEN + Utils.specsOrdered[random.nextInt(Utils.specsOrdered.length)], random.nextInt(2) == 0 ? ChatColor.BLUE.toString() + ChatColor.BOLD + "BLUE" : ChatColor.RED.toString() + ChatColor.BOLD + "RED", 0, 5, 0);
                                }
                            });
                            if (this.counter++ > 300) {
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)Warlords.getInstance(), 10L, 0L);
                    break;
                }
                case "teams": {
                    if (message.getEmbeds().isEmpty() || message.getEmbeds().get(0).getFields().size() != 2) break;
                    BotListener.cancelOnGoingBalance();
                    MessageEmbed embed = message.getEmbeds().get(0);
                    boolean isExperimental = embed.getTitle().contains("*");
                    ArrayList<String> blueTeam = new ArrayList<String>();
                    ArrayList<String> redTeam = new ArrayList<String>();
                    for (MessageEmbed.Field field : embed.getFields()) {
                        String spec;
                        String name;
                        String fieldName = field.getName();
                        String fieldValue = field.getValue();
                        if (fieldName == null || fieldValue == null) continue;
                        String[] players = fieldValue.replace("```", "").split("\n");
                        if (fieldName.contains("Blue Team")) {
                            blueTeam.add(ChatColor.DARK_BLUE.toString() + ChatColor.BOLD + "Blue Team" + ChatColor.DARK_GRAY + " - ");
                            for (String player : players) {
                                name = player.substring(0, player.indexOf(45));
                                spec = player.substring(player.indexOf(45) + 1);
                                blueTeam.add(ChatColor.BLUE + name + ChatColor.GRAY + " - " + ChatColor.YELLOW + spec);
                            }
                            continue;
                        }
                        if (!fieldName.contains("Red Team")) continue;
                        redTeam.add(ChatColor.DARK_RED.toString() + ChatColor.BOLD + "Red Team" + ChatColor.DARK_GRAY + " - ");
                        for (String player : players) {
                            name = player.substring(0, player.indexOf(45));
                            spec = player.substring(player.indexOf(45) + 1);
                            redTeam.add(ChatColor.RED + name + ChatColor.GRAY + " - " + ChatColor.YELLOW + spec);
                        }
                    }
                    AtomicBoolean resetMenu = new AtomicBoolean(true);
                    for (MessageEmbed.Field field : embed.getFields()) {
                        String fieldName = field.getName();
                        String fieldValue = field.getValue();
                        if (fieldName == null || fieldValue == null) continue;
                        boolean isBlueTeam = fieldName.contains("Blue Team");
                        boolean isRedTeam = fieldName.contains("Red Team");
                        String[] players = fieldValue.replace("```", "").replace(" ", "").split("\n");
                        try {
                            Bukkit.getScheduler().callSyncMethod((Plugin)Warlords.getInstance(), () -> {
                                for (String player : players) {
                                    String name = player.substring(0, player.indexOf(45));
                                    String spec = player.substring(player.indexOf(45) + 1);
                                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)name);
                                    if (offlinePlayer == null) continue;
                                    UUID uuid = offlinePlayer.getUniqueId();
                                    if (resetMenu.get()) {
                                        Warlords.partyManager.getPartyFromAny(uuid).ifPresent(party -> party.getRegularGamesMenu().reset());
                                        resetMenu.set(false);
                                    }
                                    if (isBlueTeam) {
                                        Warlords.getPlayerSettings(uuid).setWantedTeam(Team.BLUE);
                                    } else if (isRedTeam) {
                                        Warlords.getPlayerSettings(uuid).setWantedTeam(Team.RED);
                                    }
                                    if (!spec.isEmpty()) {
                                        Warlords.getPlayerSettings(uuid).setSelectedSpec(Specializations.getSpecFromName(spec));
                                        DatabasePlayer databasePlayer = DatabaseManager.playerService.findByUUID(uuid);
                                        if (databasePlayer != null) {
                                            databasePlayer.setLastSpec(Specializations.getSpecFromName(spec));
                                            DatabaseManager.updatePlayerAsync(databasePlayer);
                                        }
                                    }
                                    if (!isExperimental) {
                                        Warlords.partyManager.getPartyFromAny(uuid).ifPresent(party -> {
                                            if (offlinePlayer.isOnline()) {
                                                offlinePlayer.getPlayer().getInventory().setItem(7, new ItemBuilder((isBlueTeam ? Team.BLUE : Team.RED).getItem()).name("\u00a7aTeam Builder").get());
                                            }
                                        });
                                    }
                                    if (!offlinePlayer.isOnline()) continue;
                                    Player targetPlayer = offlinePlayer.getPlayer();
                                    targetPlayer.sendMessage(ChatColor.DARK_BLUE + "---------------------------------------");
                                    if (isBlueTeam) {
                                        targetPlayer.sendMessage(ChatColor.GREEN + "You were automatically put into the " + ChatColor.BLUE + "BLUE" + ChatColor.GREEN + " team!");
                                    } else if (isRedTeam) {
                                        targetPlayer.sendMessage(ChatColor.GREEN + "You were automatically put into the " + ChatColor.RED + "RED" + ChatColor.GREEN + " team!");
                                    }
                                    if (!spec.isEmpty()) {
                                        PacketUtils.sendTitle(targetPlayer, ChatColor.GREEN + spec, isBlueTeam ? ChatColor.BLUE.toString() + ChatColor.BOLD + "BLUE" : (isRedTeam ? ChatColor.RED.toString() + ChatColor.BOLD + "RED" : ""), 0, 100, 40);
                                        targetPlayer.sendMessage(ChatColor.GREEN + "Your spec was automatically changed to " + ChatColor.YELLOW + spec + ChatColor.GREEN + "!");
                                    }
                                    targetPlayer.sendMessage("");
                                    blueTeam.forEach(s2 -> {
                                        if (s2.contains(name)) {
                                            targetPlayer.sendMessage(ChatColor.GREEN + s2.substring(2, s2.indexOf(45) - 2) + s2.substring(s2.indexOf(45) - 2));
                                        } else {
                                            targetPlayer.sendMessage(s2);
                                        }
                                    });
                                    redTeam.forEach(s2 -> {
                                        if (s2.contains(name)) {
                                            targetPlayer.sendMessage(ChatColor.GREEN + s2.substring(2, s2.indexOf(45) - 2) + s2.substring(s2.indexOf(45) - 2));
                                        } else {
                                            targetPlayer.sendMessage(s2);
                                        }
                                    });
                                    targetPlayer.sendMessage(ChatColor.DARK_BLUE + "---------------------------------------");
                                }
                                return null;
                            }).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
            }
        }
    }
}

