/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.customentities.npc.traits;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.party.Party;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.HologramTrait;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class GameStartTrait
extends Trait {
    public GameStartTrait() {
        super("GameStartTrait");
    }

    public void run() {
        HologramTrait hologramTrait = (HologramTrait)this.npc.getOrAddTrait(HologramTrait.class);
        hologramTrait.setLine(0, ChatColor.YELLOW.toString() + ChatColor.BOLD + Warlords.getGameManager().getPlayerCount() + " Players");
        hologramTrait.setLine(1, ChatColor.GRAY.toString() + Warlords.getGameManager().getPlayerCountInLobby() + " in Lobby");
        hologramTrait.setLine(2, ChatColor.GRAY.toString() + Warlords.getGameManager().getQueueSize() + " in Queue");
        hologramTrait.setLine(3, ChatColor.AQUA + "WARLORDS 2 PUBLIC QUEUE");
        hologramTrait.setLine(4, ChatColor.YELLOW + ChatColor.BOLD.toString() + "CLICK TO PLAY");
        hologramTrait.setLine(5, ChatColor.YELLOW + ChatColor.BOLD.toString() + "[RANDOM MAP MODE]");
    }

    @EventHandler
    public void onRightClick(NPCRightClickEvent event) {
        if (this.getNPC() == event.getNPC()) {
            if (!Warlords.getInstance().isEnabled()) {
                this.getNPC().destroy();
                return;
            }
            this.tryToJoinQueue(event.getClicker());
        }
    }

    @EventHandler
    public void onLeftClick(NPCLeftClickEvent event) {
        if (this.getNPC() == event.getNPC()) {
            if (!Warlords.getInstance().isEnabled()) {
                this.getNPC().destroy();
                return;
            }
            this.tryToJoinQueue(event.getClicker());
        }
    }

    private void tryToJoinQueue(Player player) {
        Optional<Party> party = Warlords.partyManager.getPartyFromAny(player.getUniqueId());
        List people = party.map(Party::getAllPartyPeoplePlayerOnline).orElseGet(() -> Collections.singletonList(player));
        if (party.isPresent()) {
            if (!party.get().getPartyLeader().getUuid().equals(player.getUniqueId())) {
                player.sendMessage(ChatColor.RED + "You are not the party leader");
                return;
            }
            if (!party.get().allOnlineAndNoAFKs()) {
                player.sendMessage(ChatColor.RED + "All party members must be online or not afk");
                return;
            }
        }
        Warlords.getGameManager().newEntry(people).setCategory(GameMode.CAPTURE_THE_FLAG).setMap(null).setPriority(0).setExpiresTime(System.currentTimeMillis() + 60000L).setOnResult((result, game) -> {
            if (game == null) {
                player.sendMessage(ChatColor.RED + "Failed to join/create a game: " + (Object)result);
            }
        }).queue();
    }
}

