/*
 * Decompiled with CFR 0.152.
 */
package de.dseelp.kotlincord.api;

import de.dseelp.kotlincord.api.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001aA\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014*\u0016\u0010\u0015\"\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0012\u0004\u0012\u00020\u00170\u0016*\u0016\u0010\u0018\"\b\u0012\u0004\u0012\u00020\u00170\u00192\b\u0012\u0004\u0012\u00020\u00170\u0019\u00a8\u0006\u001a"}, d2={"gzip", "", "content", "", "randomAlphanumeric", "size", "", "lowercase", "", "uppercase", "numbers", "custom", "", "", "(IZZZ[Ljava/lang/Character;)Ljava/lang/String;", "ungzip", "validateVersion", "", "versionString", "lazyMessage", "Lkotlin/Function0;", "Dispatcher", "Lde/dseelp/kommon/command/CommandDispatcher;", "Lde/dseelp/kotlincord/api/command/Sender;", "Node", "Lde/dseelp/kommon/command/CommandNode;", "api"})
public final class UtilsKt {
    public static final void validateVersion(@NotNull String versionString, @NotNull Function0<String> lazyMessage2) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Intrinsics.checkNotNullParameter(lazyMessage2, (String)"lazyMessage");
        try {
            Version.Companion.parse(versionString).toString();
        }
        catch (Throwable t) {
            throw new IllegalStateException((String)lazyMessage2.invoke(), t);
        }
    }

    @NotNull
    public static final String randomAlphanumeric(int size, boolean lowercase, boolean uppercase, boolean numbers, @NotNull Character[] custom) {
        String lowerString;
        Intrinsics.checkNotNullParameter((Object)custom, (String)"custom");
        String string = lowerString = "abcdefghijklmnopqrstuvwxyz";
        boolean bl = false;
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        String upperString = string2;
        String numberString = "01234567890";
        String string3 = lowerString;
        boolean bl2 = false;
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        Object[] lower = ArraysKt.toTypedArray((char[])cArray);
        String string4 = upperString;
        boolean bl3 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray2 = string5.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
        Object[] upper = ArraysKt.toTypedArray((char[])cArray2);
        String string6 = numberString;
        boolean bl4 = false;
        char[] cArray3 = string6.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"(this as java.lang.String).toCharArray()");
        Object[] numberArray = ArraysKt.toTypedArray((char[])cArray3);
        Object[] allowed = custom;
        if (lowercase) {
            allowed = (Character[])ArraysKt.plus((Object[])allowed, (Object[])lower);
        }
        if (uppercase) {
            allowed = (Character[])ArraysKt.plus((Object[])allowed, (Object[])upper);
        }
        if (numbers) {
            allowed = (Character[])ArraysKt.plus((Object[])allowed, (Object[])numberArray);
        }
        Object[] objectArray = allowed;
        int n = 0;
        if (objectArray.length == 0) {
            throw new IllegalArgumentException("You must allow some sort of characters!");
        }
        Object[] array = new Character[]{};
        n = 1;
        if (n <= size) {
            int i;
            do {
                i = n++;
                char c = ((Character)allowed[Random.Default.nextInt(ArraysKt.getLastIndex((Object[])allowed))]).charValue();
                array = (Character[])ArraysKt.plus((Object[])array, (Object)Character.valueOf(c));
            } while (i != size);
        }
        return ArraysKt.joinToString$default((Object[])array, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String randomAlphanumeric$default(int n, boolean bl, boolean bl2, boolean bl3, Character[] characterArray, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x10) != 0) {
            characterArray = new Character[]{};
        }
        return UtilsKt.randomAlphanumeric(n, bl, bl2, bl3, characterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] gzip(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Object object = new GZIPOutputStream(bos);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        Closeable closeable = object;
        int n = 0;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        object = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl4 = false;
            it.write(content);
            closeable = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = bos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bos.toByteArray()");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String ungzip(@NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = content;
        boolean bl = false;
        object = new GZIPInputStream(new ByteArrayInputStream((byte[])object));
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl2 = false;
        Object object2 = object;
        int n = 0;
        object2 = new InputStreamReader((InputStream)object2, charset);
        n = 8192;
        boolean bl3 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean bl4 = false;
        bl2 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return object2;
    }
}

