/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge.event.message.passive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.dreamvoid.miraimc.api.bot.MiraiGroup;
import me.dreamvoid.miraimc.event.EventType;
import me.dreamvoid.miraimc.httpapi.MiraiHttpAPI;
import me.dreamvoid.miraimc.httpapi.exception.AbnormalStatusException;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import me.dreamvoid.miraimc.internal.Utils;
import me.dreamvoid.miraimc.sponge.event.message.passive.AbstractMessageEvent;
import net.mamoe.mirai.contact.ContactList;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageSource;
import org.spongepowered.api.event.cause.Cause;

public class MiraiGroupMessageEvent
extends AbstractMessageEvent {
    private GroupMessageEvent event;
    private final long BotID;
    private final String MemberName;
    private final int Permission;
    private final long GroupID;
    private final String GroupName;
    private final int GroupPermission;

    public MiraiGroupMessageEvent(GroupMessageEvent event, Cause cause) {
        super((MessageEvent)event, cause);
        this.event = event;
        this.BotID = event.getBot().getId();
        this.MemberName = event.getSender().getNameCard();
        this.Permission = event.getSender().getPermission().getLevel();
        this.GroupID = event.getGroup().getId();
        this.GroupName = event.getGroup().getName();
        this.GroupPermission = event.getGroup().getBotPermission().getLevel();
    }

    public MiraiGroupMessageEvent(long BotID, FetchMessage.Data data, Cause cause) {
        super(BotID, data, cause);
        this.BotID = BotID;
        this.MemberName = data.sender.memberName;
        switch (data.sender.permission) {
            case "OWNER": {
                this.Permission = 2;
                break;
            }
            case "ADMINISTRATOR": {
                this.Permission = 1;
                break;
            }
            default: {
                this.Permission = 0;
            }
        }
        this.GroupID = data.sender.group.id;
        this.GroupName = data.sender.group.name;
        switch (data.sender.group.permission) {
            case "OWNER": {
                this.GroupPermission = 2;
                break;
            }
            case "ADMINISTRATOR": {
                this.GroupPermission = 1;
                break;
            }
            default: {
                this.GroupPermission = 0;
            }
        }
    }

    public long getGroupID() {
        return this.GroupID;
    }

    public String getGroupName() {
        return this.GroupName;
    }

    public String getSenderNameCard() {
        return this.MemberName;
    }

    public int getSenderPermission() {
        return this.Permission;
    }

    public int getBotMuteRemainTime() {
        if (this.isMuteAll() && this.getBotPermission() == 0) {
            return -1;
        }
        return this.event.getGroup().getBotMuteRemaining();
    }

    public List<Long> getGroupMemberList() {
        ContactList GroupMemberListOrigin = this.event.getGroup().getMembers();
        ArrayList<Long> GroupMemberList = new ArrayList<Long>();
        for (NormalMember Member2 : GroupMemberListOrigin) {
            GroupMemberList.add(Member2.getId());
        }
        return GroupMemberList;
    }

    public int getBotPermission() {
        return this.GroupPermission;
    }

    public boolean isAllowMemberInvite() {
        return this.event.getGroup().getSettings().isAllowMemberInvite();
    }

    public boolean isAnonymousChatEnabled() {
        return this.event.getGroup().getSettings().isAnonymousChatEnabled();
    }

    public boolean isMuteAll() {
        return this.event.getGroup().getSettings().isMuteAll();
    }

    public boolean isAutoApproveEnabled() {
        return this.event.getGroup().getSettings().isAutoApproveEnabled();
    }

    public void recall() {
        MessageSource.recall((MessageChain)this.event.getMessage());
    }

    public void recall(long delayTime) {
        MessageSource.recallIn((MessageChain)this.event.getMessage(), (long)delayTime);
    }

    @Override
    public void sendMessage(String message) {
        if (this.getType() == EventType.CORE) {
            super.sendMessage(message);
        } else if (this.getType() == EventType.HTTPAPI) {
            try {
                MiraiHttpAPI.INSTANCE.sendGroupMessage(MiraiHttpAPI.Bots.get(this.BotID), this.GroupID, message);
            }
            catch (IOException | AbnormalStatusException e) {
                Utils.logger.warning("\u53d1\u9001\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            }
        }
    }

    @Override
    public void sendMessageMirai(String message) {
        if (this.getType() == EventType.CORE) {
            super.sendMessageMirai(message);
        } else if (this.getType() == EventType.HTTPAPI) {
            try {
                MiraiHttpAPI.INSTANCE.sendGroupMessage(MiraiHttpAPI.Bots.get(this.BotID), this.GroupID, message);
            }
            catch (IOException | AbnormalStatusException e) {
                Utils.logger.warning("\u53d1\u9001\u6d88\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            }
        }
    }

    public MiraiGroup getGroup() {
        return new MiraiGroup(this.event.getBot(), this.event.getGroup().getId());
    }
}

