/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge.event.message;

import net.mamoe.mirai.event.events.ImageUploadEvent;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.impl.AbstractEvent;

public class MiraiImageUploadEvent
extends AbstractEvent {
    private final Cause cause;
    private final ImageUploadEvent event;

    public MiraiImageUploadEvent(ImageUploadEvent event, Cause cause) {
        this.event = event;
        this.cause = cause;
    }

    public long getBotID() {
        return this.event.getBot().getId();
    }

    public long getTargetID() {
        return this.event.getTarget().getId();
    }

    public String calculateResourceID() {
        return this.event.getSource().calculateResourceId();
    }

    public byte[] getImageMd5() {
        return this.event.getSource().getMd5();
    }

    public byte[] getImageSha1() {
        return this.event.getSource().getSha1();
    }

    public String getImageName() {
        return this.event.getSource().getFormatName();
    }

    public long getImageSize() {
        return this.event.getSource().getSize();
    }

    public String toString() {
        return this.event.toString();
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    public static class Failed
    extends MiraiImageUploadEvent {
        final ImageUploadEvent.Failed event;

        public Failed(ImageUploadEvent.Failed event, Cause cause) {
            super((ImageUploadEvent)event, cause);
            this.event = event;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public int getErrorID() {
            return this.event.getErrno();
        }
    }

    public static class Succeed
    extends MiraiImageUploadEvent {
        final ImageUploadEvent.Succeed event;

        public Succeed(ImageUploadEvent.Succeed event, Cause cause) {
            super((ImageUploadEvent)event, cause);
            this.event = event;
        }

        public String getImageID() {
            return this.event.getImage().getImageId();
        }

        public String getMiraiMsg() {
            return this.event.getImage().serializeToMiraiCode();
        }

        public boolean isEmoji() {
            return this.event.getImage().isEmoji();
        }
    }
}

