/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.dreamvoid.miraimc.api.MiraiBot;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.MiraiLoginSolver;
import me.dreamvoid.miraimc.internal.Utils;
import me.dreamvoid.miraimc.internal.classloader.MiraiLoader;
import me.dreamvoid.miraimc.sponge.Events;
import me.dreamvoid.miraimc.sponge.MiraiAutoLogin;
import me.dreamvoid.miraimc.sponge.MiraiEvent;
import me.dreamvoid.miraimc.sponge.MiraiEventLegacy;
import me.dreamvoid.miraimc.sponge.MiraiHttpAPIResolver;
import me.dreamvoid.miraimc.sponge.SpongeConfig;
import me.dreamvoid.miraimc.sponge.SpongeLogger;
import me.dreamvoid.miraimc.sponge.commands.MiraiCommand;
import me.dreamvoid.miraimc.sponge.commands.MiraiMcCommand;
import me.dreamvoid.miraimc.sponge.commands.MiraiVerifyCommand;
import me.dreamvoid.miraimc.sponge.utils.Metrics;
import me.dreamvoid.miraimc.webapi.Info;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingServerEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.metric.MetricsConfigManager;

@Plugin(id="miraimc", name="MiraiMC", description="MiraiBot for Minecraft server", version="1.7-rc2", url="https://github.com/DreamVoid/MiraiMC", authors={"DreamVoid"})
public class SpongePlugin {
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private File dataFolder;
    @Inject
    private PluginContainer pluginContainer;
    @Inject
    private MetricsConfigManager metricsConfigManager;
    private MiraiEvent MiraiEvent;
    private MiraiAutoLogin MiraiAutoLogin;

    @Listener
    public void onLoad(GamePreInitializationEvent e) {
        try {
            SpongeLogger log4j = new SpongeLogger("MiraiMC", null, this);
            Utils.setLogger(log4j);
            Utils.setClassLoader(this.getClass().getClassLoader());
            new SpongeConfig(this).loadConfig();
            if (Config.General.MiraiCoreVersion.equalsIgnoreCase("latest")) {
                MiraiLoader.loadMiraiCore();
            } else if (Config.General.MiraiCoreVersion.equalsIgnoreCase("stable")) {
                MiraiLoader.loadMiraiCore(MiraiLoader.getStableVersion(this.getPluginContainer().getVersion().orElse("1.0")));
            } else {
                MiraiLoader.loadMiraiCore(Config.General.MiraiCoreVersion);
            }
            this.MiraiEvent = !Config.General.LegacyEventSupport ? new MiraiEvent(this) : new MiraiEventLegacy(this);
            this.MiraiAutoLogin = new MiraiAutoLogin(this);
        }
        catch (Exception ex) {
            this.getLogger().warn("An error occurred while loading plugin.");
            ex.printStackTrace();
        }
    }

    @Listener
    public void onEnable(GameInitializationEvent e) {
        this.getLogger().info("Mirai working dir: " + Config.General.MiraiWorkingDir);
        if (Config.General.AddProperties.MiraiNoDesktop) {
            System.setProperty("mirai.no-desktop", "MiraiMC");
        }
        if (Config.General.AddProperties.MiraiSliderCaptchaSupported) {
            System.setProperty("mirai.slider.captcha.supported", "MiraiMC");
        }
        this.getLogger().info("Starting Mirai-Events listener.");
        this.MiraiEvent.startListenEvent();
        this.getLogger().info("Loading auto-login file.");
        this.MiraiAutoLogin.loadFile();
        this.MiraiAutoLogin.doStartUpAutoLogin();
        if (Config.Bot.LogEvents) {
            this.getLogger().info("Registering events.");
            Sponge.getEventManager().registerListeners((Object)this, (Object)new Events());
        }
        switch (Config.Database.Type.toLowerCase()) {
            default: {
                this.getLogger().info("Initializing SQLite database.");
                try {
                    Utils.initializeSQLite();
                }
                catch (ClassNotFoundException | SQLException ex) {
                    this.getLogger().warn("Failed to initialize SQLite database, reason: " + e);
                }
                break;
            }
            case "mysql": {
                this.getLogger().info("Initializing MySQL database.");
                Utils.initializeMySQL();
            }
        }
        if (Config.General.AllowBStats) {
            if (this.metricsConfigManager.getCollectionState(this.pluginContainer).asBoolean()) {
                this.getLogger().info("Initializing bStats metrics.");
                int pluginId = 12847;
                new Metrics(this.pluginContainer, this.getLogger(), this.getDataFolder().toPath(), pluginId);
            } else {
                this.getLogger().warn("\u4f60\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u542f\u7528\u4e86bStats\uff0c\u4f46\u662fMetricsConfigManager\u544a\u77e5MiraiMC\u4e0d\u5141\u8bb8\u6536\u96c6\u4fe1\u606f\uff0c\u56e0\u6b64bStats\u5df2\u5173\u95ed");
                this.getLogger().warn("\u8981\u542f\u7528bStats\uff0c\u8bf7\u6267\u884c\u547d\u4ee4 /sponge metrics miraimc enable");
                this.getLogger().warn("\u6216\u8005\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u7981\u7528bStats\u9690\u85cf\u6b64\u8b66\u544a");
            }
        }
        if (Config.General.EnableHttpApi) {
            this.getLogger().info("Initializing HttpAPI async task.");
            Sponge.getScheduler().createTaskBuilder().async().execute((Runnable)new MiraiHttpAPIResolver(this)).intervalTicks(Config.HttpApi.MessageFetch.Interval).name("MiraiMC-HttpApi").submit((Object)this);
        }
        if (!Config.General.DisableSafeWarningMessage) {
            this.getLogger().warn("\u786e\u4fdd\u60a8\u6b63\u5728\u4f7f\u7528\u5f00\u6e90\u7684MiraiMC\u63d2\u4ef6\uff0c\u672a\u77e5\u6765\u6e90\u7684\u63d2\u4ef6\u53ef\u80fd\u4f1a\u76d7\u53d6\u60a8\u7684\u8d26\u53f7\uff01");
            this.getLogger().warn("\u8bf7\u59cb\u7ec8\u4eceGithub\u6216\u4f5c\u8005\u6307\u5b9a\u7684\u5176\u4ed6\u9014\u5f84\u4e0b\u8f7d\u63d2\u4ef6: https://github.com/DreamVoid/MiraiMC");
        }
        Sponge.getScheduler().createAsyncExecutor((Object)this).schedule(() -> {
            try {
                List<String> announcement = Info.init().announcement;
                if (announcement != null) {
                    this.getLogger().info("========== [ MiraiMC \u516c\u544a\u7248 ] ==========");
                    announcement.forEach(s -> this.getLogger().info(s));
                    this.getLogger().info("=======================================");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 2L, TimeUnit.SECONDS);
        this.getLogger().info("Some initialization tasks will continue to run afterwards.");
        this.getLogger().info("All tasks done. Welcome to use MiraiMC!");
    }

    @Listener
    public void onServerLoaded(GameStartingServerEvent e) {
        this.getLogger().info("Registering commands.");
        CommandSpec mirai = CommandSpec.builder().description((Text)Text.of((String)"MiraiMC Bot Command.")).permission("miraimc.command.mirai").executor((CommandExecutor)new MiraiCommand(this)).arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args"))).build();
        CommandSpec miraimc = CommandSpec.builder().description((Text)Text.of((String)"MiraiMC Plugin Command.")).permission("miraimc.command.miraimc").executor((CommandExecutor)new MiraiMcCommand(this)).arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args"))).build();
        CommandSpec miraiverify = CommandSpec.builder().description((Text)Text.of((String)"MiraiMC LoginVerify Command.")).permission("miraimc.command.miraiverify").executor((CommandExecutor)new MiraiVerifyCommand(this)).arguments(GenericArguments.remainingJoinedStrings((Text)Text.of((String)"args"))).build();
        Sponge.getCommandManager().register((Object)this, (CommandCallable)mirai, new String[]{"mirai"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)miraimc, new String[]{"miraimc"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)miraiverify, new String[]{"miraiverify"});
    }

    @Listener
    public void onServerStopping(GameStoppingServerEvent event) {
        if (this.MiraiEvent != null) {
            this.getLogger().info("Stopping bot event listener.");
            this.MiraiEvent.stopListenEvent();
        }
        this.getLogger().info("Closing all bots");
        MiraiLoginSolver.cancelAll();
        Object object = MiraiBot.getOnlineBots().iterator();
        while (object.hasNext()) {
            long bots = object.next();
            MiraiBot.getBot(bots).close();
        }
        switch (Config.Database.Type.toLowerCase()) {
            default: {
                if (Utils.connection == null) break;
                this.getLogger().info("Closing SQLite database.");
                try {
                    Utils.closeSQLite();
                }
                catch (SQLException e) {
                    this.getLogger().error("Failed to close SQLite database!");
                    this.getLogger().error("Reason: " + e);
                }
                break;
            }
            case "mysql": {
                if (Utils.ds == null) break;
                this.getLogger().info("Closing MySQL database.");
                Utils.closeMySQL();
            }
        }
        this.getLogger().info("All tasks done. Thanks for use MiraiMC!");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }
}

