/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.sponge.SpongePlugin;
import org.yaml.snakeyaml.Yaml;

public class SpongeConfig {
    private final SpongePlugin plugin;
    private static SpongeConfig Instance;

    public SpongeConfig(SpongePlugin plugin) {
        Instance = this;
        this.plugin = plugin;
        Config.PluginDir = plugin.getDataFolder();
    }

    public void loadConfig() throws IOException {
        FileInputStream inputStream;
        Yaml yaml;
        Map obj;
        if (!Config.PluginDir.exists() && !Config.PluginDir.mkdirs()) {
            throw new RuntimeException("Failed to create data folder!");
        }
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            try (InputStream is = this.plugin.getClass().getResourceAsStream("/config.yml");){
                assert (is != null);
                Files.copy(is, file.toPath(), new CopyOption[0]);
            }
        }
        Map general = !Objects.isNull((obj = (Map)(yaml = new Yaml()).load((InputStream)(inputStream = new FileInputStream(file)))).get("general")) ? (Map)obj.get("general") : new HashMap();
        Config.General.AllowBStats = !Objects.isNull(general.get("allow-bStats")) ? (Boolean)general.get("allow-bStats") : false;
        Config.General.CheckUpdate = !Objects.isNull(general.get("check-update")) ? (Boolean)general.get("check-update") : false;
        Config.General.DisableSafeWarningMessage = !Objects.isNull(general.get("disable-safe-warning-message")) ? (Boolean)general.get("disable-safe-warning-message") : false;
        Config.General.MiraiWorkingDir = !Objects.isNull(general.get("mirai-working-dir")) ? String.valueOf(general.get("mirai-working-dir")) : "default";
        Map addProperties = !Objects.isNull(general.get("add-properties")) ? (Map)general.get("add-properties") : new HashMap();
        Config.General.AddProperties.MiraiNoDesktop = !Objects.isNull(addProperties.get("mirai.no-desktop")) ? (Boolean)addProperties.get("mirai.no-desktop") : true;
        Config.General.AddProperties.MiraiSliderCaptchaSupported = !Objects.isNull(addProperties.get("mirai.slider.captcha.supported")) ? (Boolean)addProperties.get("mirai.slider.captcha.supported") : true;
        Config.General.MiraiCoreVersion = !Objects.isNull(general.get("mirai-core-version")) ? String.valueOf(general.get("mirai-core-version")) : "latest";
        Config.General.MavenRepoUrl = !Objects.isNull(general.get("maven-repo-url")) ? String.valueOf(general.get("maven-repo-url")) : "https://maven.aliyun.com/nexus/content/groups/public/";
        Config.General.EnableHttpApi = !Objects.isNull(general.get("enable-http-api")) ? (Boolean)general.get("enable-http-api") : false;
        Config.General.LegacyEventSupport = !Objects.isNull(general.get("legacy-event-support")) ? (Boolean)general.get("legacy-event-support") : false;
        Map bot = !Objects.isNull(obj.get("bot")) ? (Map)obj.get("bot") : new HashMap();
        Config.Bot.DisableNetworkLogs = !Objects.isNull(bot.get("disable-network-logs")) ? (Boolean)bot.get("disable-network-logs") : false;
        Config.Bot.DisableBotLogs = !Objects.isNull(bot.get("disable-bot-logs")) ? (Boolean)bot.get("disable-bot-logs") : false;
        Map useBukkitLogger = !Objects.isNull(bot.get("use-minecraft-logger")) ? (Map)bot.get("use-minecraft-logger") : new HashMap();
        Config.Bot.UseMinecraftLogger.BotLogs = !Objects.isNull(useBukkitLogger.get("bot-logs")) ? (Boolean)useBukkitLogger.get("bot-logs") : true;
        Config.Bot.UseMinecraftLogger.NetworkLogs = !Objects.isNull(useBukkitLogger.get("network-logs")) ? (Boolean)useBukkitLogger.get("network-logs") : true;
        Config.Bot.LogEvents = !Objects.isNull(bot.get("log-events")) ? (Boolean)bot.get("log-events") : true;
        Map contactCache = !Objects.isNull(bot.get("contact-cache")) ? (Map)bot.get("contact-cache") : new HashMap();
        Config.Bot.ContactCache.EnableFriendListCache = !Objects.isNull(contactCache.get("enable-friend-list-cache")) ? (Boolean)contactCache.get("enable-friend-list-cache") : false;
        Config.Bot.ContactCache.EnableGroupMemberListCache = !Objects.isNull(contactCache.get("enable-group-member-list-cache")) ? (Boolean)contactCache.get("enable-group-member-list-cache") : false;
        Config.Bot.ContactCache.SaveIntervalMillis = !Objects.isNull(contactCache.get("save-interval-millis")) ? Long.parseLong(String.valueOf(contactCache.get("save-interval-millis"))) : 60000L;
        Map database = !Objects.isNull(obj.get("database")) ? (Map)obj.get("database") : new HashMap();
        Config.Database.Type = !Objects.isNull(database.get("type")) ? String.valueOf(database.get("type")).toLowerCase() : "sqlite";
        Map mysql = !Objects.isNull(database.get("mysql")) ? (Map)database.get("mysql") : new HashMap();
        Config.Database.MySQL.Address = !Objects.isNull(mysql.get("address")) ? String.valueOf(mysql.get("address")) : "localhost";
        Config.Database.MySQL.Username = !Objects.isNull(mysql.get("username")) ? String.valueOf(mysql.get("username")) : "miraimc";
        Config.Database.MySQL.Password = !Objects.isNull(mysql.get("password")) ? String.valueOf(mysql.get("password")) : "miraimc";
        Config.Database.MySQL.Database = !Objects.isNull(mysql.get("database")) ? String.valueOf(mysql.get("database")) : "miraimc";
        Map pool = !Objects.isNull(mysql.get("pool")) ? (Map)mysql.get("pool") : new HashMap();
        Config.Database.MySQL.Poll.ConnectionTimeout = !Objects.isNull(pool.get("connectionTimeout")) ? (Integer)pool.get("connectionTimeout") : 30000;
        Config.Database.MySQL.Poll.IdleTimeout = !Objects.isNull(pool.get("connectionTimeout")) ? (Integer)pool.get("connectionTimeout") : 600000;
        Config.Database.MySQL.Poll.MaxLifetime = !Objects.isNull(pool.get("maxLifetime")) ? (Integer)pool.get("maxLifetime") : 1800000;
        Config.Database.MySQL.Poll.MaximumPoolSize = !Objects.isNull(pool.get("maximumPoolSize")) ? (Integer)pool.get("maximumPoolSize") : 15;
        Config.Database.MySQL.Poll.KeepaliveTime = !Objects.isNull(pool.get("keepaliveTime")) ? (Integer)pool.get("keepaliveTime") : 0;
        Config.Database.MySQL.Poll.MinimumIdle = !Objects.isNull(pool.get("minimumIdle")) ? (Integer)pool.get("minimumIdle") : 5;
    }

    public static void reloadConfig() throws IOException {
        Instance.loadConfig();
    }
}

