/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge;

import me.dreamvoid.miraimc.httpapi.MiraiHttpAPI;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.sponge.SpongePlugin;
import me.dreamvoid.miraimc.sponge.event.message.passive.MiraiFriendMessageEvent;
import me.dreamvoid.miraimc.sponge.event.message.passive.MiraiGroupMessageEvent;
import me.dreamvoid.miraimc.sponge.event.message.passive.MiraiGroupTempMessageEvent;
import me.dreamvoid.miraimc.sponge.event.message.passive.MiraiOtherClientMessageEvent;
import me.dreamvoid.miraimc.sponge.event.message.passive.MiraiStrangerMessageEvent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.plugin.PluginContainer;

public class MiraiHttpAPIResolver
implements Runnable {
    private final SpongePlugin plugin;
    private final EventContext eventContext;
    private final PluginContainer pluginContainer;

    public MiraiHttpAPIResolver(SpongePlugin plugin) {
        this.plugin = plugin;
        this.pluginContainer = plugin.getPluginContainer();
        this.eventContext = EventContext.builder().add(EventContextKeys.PLUGIN, (Object)this.pluginContainer).build();
    }

    @Override
    public void run() {
        MiraiHttpAPI api = new MiraiHttpAPI(Config.HttpApi.Url);
        for (long account : MiraiHttpAPI.Bots.keySet()) {
            try {
                String session = MiraiHttpAPI.Bots.get(account);
                FetchMessage fetchMessage = api.fetchMessage(session, Config.HttpApi.MessageFetch.Count);
                if (fetchMessage.code == 0) {
                    for (FetchMessage.Data data : fetchMessage.data) {
                        String type;
                        switch (type = data.type) {
                            case "FriendMessage": {
                                Sponge.getEventManager().post((Event)new MiraiFriendMessageEvent(account, data, Cause.of((EventContext)this.eventContext, (Object)this.pluginContainer)));
                                break;
                            }
                            case "GroupMessage": {
                                Sponge.getEventManager().post((Event)new MiraiGroupMessageEvent(account, data, Cause.of((EventContext)this.eventContext, (Object)this.pluginContainer)));
                                break;
                            }
                            case "TempMessage": {
                                Sponge.getEventManager().post((Event)new MiraiGroupTempMessageEvent(account, data, Cause.of((EventContext)this.eventContext, (Object)this.pluginContainer)));
                                break;
                            }
                            case "StrangerMessage": {
                                Sponge.getEventManager().post((Event)new MiraiStrangerMessageEvent(account, data, Cause.of((EventContext)this.eventContext, (Object)this.pluginContainer)));
                                break;
                            }
                            case "OtherClientMessage": {
                                Sponge.getEventManager().post((Event)new MiraiOtherClientMessageEvent(account, data, Cause.of((EventContext)this.eventContext, (Object)this.pluginContainer)));
                            }
                        }
                    }
                    continue;
                }
                this.plugin.getLogger().warn("Unable to fetch " + account + "'s message, reason: " + fetchMessage.msg);
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("An error occurred while fetching message for " + account + ": " + e);
            }
        }
    }
}

