/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.sponge;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import me.dreamvoid.miraimc.api.MiraiBot;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.sponge.SpongePlugin;
import me.dreamvoid.miraimc.sponge.utils.AutoLoginObject;
import net.mamoe.mirai.utils.BotConfiguration;
import org.slf4j.Logger;
import org.spongepowered.api.scheduler.Task;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.nodes.Tag;

public class MiraiAutoLogin {
    private final SpongePlugin plugin;
    private final Logger Logger;
    private static File AutoLoginFile;
    public static MiraiAutoLogin Instance;

    public MiraiAutoLogin(SpongePlugin plugin) {
        this.plugin = plugin;
        this.Logger = plugin.getLogger();
        Instance = this;
    }

    public void loadFile() {
        File MiraiDir = !Config.General.MiraiWorkingDir.equals("default") ? new File(Config.General.MiraiWorkingDir) : new File(Config.PluginDir, "MiraiBot");
        File ConsoleDir = new File(MiraiDir, "config/Console");
        if (!ConsoleDir.exists() && !ConsoleDir.mkdirs()) {
            throw new RuntimeException("Failed to create folder " + ConsoleDir.getPath());
        }
        AutoLoginFile = new File(ConsoleDir, "AutoLogin.yml");
        if (!AutoLoginFile.exists()) {
            try {
                if (!AutoLoginFile.createNewFile()) {
                    throw new RuntimeException("Failed to create folder " + AutoLoginFile.getPath());
                }
                String defaultText = "accounts: " + System.getProperty("line.separator");
                File writeName = AutoLoginFile;
                try (FileWriter writer = new FileWriter(writeName);
                     BufferedWriter out = new BufferedWriter(writer);){
                    out.write(defaultText);
                    out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<AutoLoginObject.Accounts> loadAutoLoginList() throws IOException {
        InputStream inputStream;
        Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(MiraiAutoLogin.class.getClassLoader()));
        AutoLoginObject data = (AutoLoginObject)yaml.loadAs(inputStream = Files.newInputStream(AutoLoginFile.toPath(), new OpenOption[0]), AutoLoginObject.class);
        if (data.getAccounts() == null) {
            data.setAccounts(new ArrayList<AutoLoginObject.Accounts>());
        }
        return data.getAccounts();
    }

    public void doStartUpAutoLogin() {
        Runnable thread = () -> {
            try {
                this.Logger.info("[AutoLogin] Starting auto login task.");
                for (AutoLoginObject.Accounts accounts : MiraiAutoLogin.loadAutoLoginList()) {
                    AutoLoginObject.Password password = accounts.getPassword();
                    AutoLoginObject.Configuration configuration = accounts.getConfiguration();
                    long Account = accounts.getAccount();
                    if (Account == 123456L) continue;
                    try {
                        BotConfiguration.MiraiProtocol Protocol;
                        String Password2 = password.getValue();
                        try {
                            Protocol = BotConfiguration.MiraiProtocol.valueOf((String)configuration.getProtocol().toUpperCase());
                        }
                        catch (IllegalArgumentException ignored) {
                            this.Logger.warn("[AutoLogin] Unknown protocol " + configuration.getProtocol().toUpperCase() + ", using ANDROID_PHONE instead.");
                            Protocol = BotConfiguration.MiraiProtocol.ANDROID_PHONE;
                        }
                        this.Logger.info("[AutoLogin] Auto login bot account: " + Account + " Protocol: " + Protocol.name());
                        MiraiBot.doBotLogin(Account, Password2, Protocol);
                    }
                    catch (IllegalArgumentException ex) {
                        this.Logger.warn("\u8bfb\u53d6\u81ea\u52a8\u767b\u5f55\u6587\u4ef6\u65f6\u53d1\u73b0\u672a\u77e5\u7684\u534f\u8bae\u7c7b\u578b\uff0c\u8bf7\u4fee\u6539: " + configuration.getProtocol());
                    }
                }
            }
            catch (IOException e) {
                this.Logger.warn("\u767b\u5f55\u673a\u5668\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
            }
        };
        Task.builder().async().name("MiraiMC Autologin Task").execute(thread).submit((Object)this.plugin);
    }

    public static boolean addAutoLoginBot(long Account, String Password2, String Protocol) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(MiraiAutoLogin.class.getClassLoader()));
            InputStream inputStream = Files.newInputStream(AutoLoginFile.toPath(), new OpenOption[0]);
            AutoLoginObject data = (AutoLoginObject)yaml.loadAs(inputStream, AutoLoginObject.class);
            if (data.getAccounts() == null) {
                data.setAccounts(new ArrayList<AutoLoginObject.Accounts>());
            }
            AutoLoginObject.Accounts account = new AutoLoginObject.Accounts();
            account.setAccount(Account);
            AutoLoginObject.Password password = new AutoLoginObject.Password();
            password.setKind("PLAIN");
            password.setValue(Password2);
            account.setPassword(password);
            AutoLoginObject.Configuration configuration = new AutoLoginObject.Configuration();
            configuration.setDevice("device.json");
            configuration.setProtocol(Protocol.toUpperCase());
            account.setConfiguration(configuration);
            List<AutoLoginObject.Accounts> accounts = data.getAccounts();
            accounts.add(account);
            data.setAccounts(accounts);
            Yaml yaml1 = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(MiraiAutoLogin.class.getClassLoader()));
            File writeName = AutoLoginFile;
            try (FileWriter writer = new FileWriter(writeName);
                 BufferedWriter out = new BufferedWriter(writer);){
                out.write(yaml1.dumpAs((Object)data, Tag.MAP, DumperOptions.FlowStyle.BLOCK));
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean delAutoLoginBot(long Account) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(MiraiAutoLogin.class.getClassLoader()));
            InputStream inputStream = Files.newInputStream(AutoLoginFile.toPath(), new OpenOption[0]);
            AutoLoginObject data = (AutoLoginObject)yaml.loadAs(inputStream, AutoLoginObject.class);
            if (data.getAccounts() == null) {
                data.setAccounts(new ArrayList<AutoLoginObject.Accounts>());
            }
            for (AutoLoginObject.Accounts bots : data.getAccounts()) {
                if (bots.getAccount() != Account) continue;
                data.getAccounts().remove(bots);
                break;
            }
            Yaml yaml1 = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(MiraiAutoLogin.class.getClassLoader()));
            File writeName = AutoLoginFile;
            try (FileWriter writer = new FileWriter(writeName);
                 BufferedWriter out = new BufferedWriter(writer);){
                out.write(yaml1.dumpAs((Object)data, Tag.MAP, DumperOptions.FlowStyle.BLOCK));
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

