/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.libraries.org.apache.http.impl.cookie;

import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.Contract;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.ThreadingBehavior;
import me.dreamvoid.miraimc.libraries.org.apache.http.cookie.CommonCookieAttributeHandler;
import me.dreamvoid.miraimc.libraries.org.apache.http.cookie.Cookie;
import me.dreamvoid.miraimc.libraries.org.apache.http.cookie.CookieOrigin;
import me.dreamvoid.miraimc.libraries.org.apache.http.cookie.MalformedCookieException;
import me.dreamvoid.miraimc.libraries.org.apache.http.cookie.SetCookie;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import me.dreamvoid.miraimc.libraries.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

