/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.libraries.org.apache.http.client.protocol;

import java.io.IOException;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpEntity;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpEntityEnclosingRequest;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpException;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpRequest;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpRequestInterceptor;
import me.dreamvoid.miraimc.libraries.org.apache.http.HttpVersion;
import me.dreamvoid.miraimc.libraries.org.apache.http.ProtocolVersion;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.Contract;
import me.dreamvoid.miraimc.libraries.org.apache.http.annotation.ThreadingBehavior;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.config.RequestConfig;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.protocol.HttpClientContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.protocol.HttpContext;
import me.dreamvoid.miraimc.libraries.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

