/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.internal.classloader;

import com.google.common.base.Suppliers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.Utils;
import me.dreamvoid.miraimc.internal.classloader.URLClassLoaderAccess;
import me.dreamvoid.miraimc.libraries.org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LibrariesLoader {
    private static final Supplier<URLClassLoaderAccess> LOADER = () -> (URLClassLoaderAccess)Suppliers.memoize(() -> URLClassLoaderAccess.create((URLClassLoader)Utils.classLoader)).get();

    private static void downloadFile(File file, URL url) throws IOException {
        try (InputStream is = url.openStream();){
            Files.copy(is, file.toPath(), new CopyOption[0]);
        }
    }

    static boolean downloadLibraryMaven(String groupId, String artifactId, String version, String extra, String repo, File file, boolean checkMD5) throws RuntimeException, IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new RuntimeException("Failed to create " + file.getParentFile().getPath());
        }
        if (!repo.endsWith("/")) {
            repo = repo + "/";
        }
        repo = repo + "%s/%s/%s/%s-%s%s.jar";
        String DownloadURL = String.format(repo, groupId.replace(".", "/"), artifactId, version, artifactId, version, extra);
        String FileName = artifactId + "-" + version + ".jar";
        if (checkMD5) {
            FileInputStream fis;
            boolean isSame;
            File FileMD5 = new File(file.getParentFile(), FileName + ".md5");
            String DownloadMD5Url = DownloadURL + ".md5";
            URL DownloadMD5UrlFormat = new URL(DownloadMD5Url);
            if (FileMD5.exists() && !FileMD5.delete()) {
                throw new RuntimeException("Failed to delete " + FileMD5.getPath());
            }
            LibrariesLoader.downloadFile(FileMD5, DownloadMD5UrlFormat);
            if (!FileMD5.exists()) {
                throw new RuntimeException("Failed to download " + DownloadMD5Url);
            }
            if (file.exists() && !(isSame = DigestUtils.md5Hex(fis = new FileInputStream(file)).equals(new String(Files.readAllBytes(FileMD5.toPath()), StandardCharsets.UTF_8)))) {
                fis.close();
                if (!file.delete()) {
                    throw new RuntimeException("Failed to delete " + file.getPath());
                }
            }
        } else if (file.exists() && !file.delete()) {
            throw new RuntimeException("Failed to delete " + file.getPath());
        }
        if (!file.exists()) {
            Utils.logger.info("Downloading " + DownloadURL);
            LibrariesLoader.downloadFile(file, new URL(DownloadURL));
        }
        return file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getLibraryVersionMaven(String groupId, String artifactId, String repoUrl, String xmlTag) throws RuntimeException, IOException, ParserConfigurationException, SAXException {
        File metaFile;
        block14: {
            File CacheDir = new File(Config.PluginDir, "cache");
            if (!CacheDir.exists() && !CacheDir.mkdirs()) {
                throw new RuntimeException("Failed to create " + CacheDir.getPath());
            }
            String metaFileName = "maven-metadata-" + groupId + "." + artifactId + ".xml";
            metaFile = new File(CacheDir, metaFileName);
            if (!repoUrl.endsWith("/")) {
                repoUrl = repoUrl + "/";
            }
            repoUrl = repoUrl + "%s/%s/";
            String repoFormat = String.format(repoUrl, groupId.replace(".", "/"), artifactId);
            File metaFileMD5 = new File(CacheDir, metaFileName + ".md5");
            if (metaFileMD5.exists() && !metaFileMD5.delete()) {
                throw new RuntimeException("Failed to delete " + metaFileMD5.getPath());
            }
            URL metaFileMD5Url = new URL(repoFormat + "maven-metadata.xml.md5");
            LibrariesLoader.downloadFile(metaFileMD5, metaFileMD5Url);
            if (!metaFileMD5.exists()) {
                throw new RuntimeException("Failed to download " + metaFileMD5Url);
            }
            Utils.logger.info("Verifying " + metaFileName);
            if (metaFile.exists()) {
                try (FileInputStream fis = new FileInputStream(metaFile);){
                    if (!DigestUtils.md5Hex(fis).equals(new String(Files.readAllBytes(metaFileMD5.toPath()), StandardCharsets.UTF_8))) {
                        fis.close();
                        if (!metaFile.delete()) {
                            throw new RuntimeException("Failed to delete " + metaFile.getPath());
                        }
                        URL metaFileUrl = new URL(repoFormat + "maven-metadata.xml");
                        LibrariesLoader.downloadFile(metaFile, metaFileUrl);
                        if (!metaFileMD5.exists()) {
                            throw new RuntimeException("Failed to download " + metaFileUrl);
                        }
                    }
                    break block14;
                }
            }
            URL metaFileUrl = new URL(repoFormat + "maven-metadata.xml");
            Utils.logger.info("Downloading " + metaFileUrl);
            LibrariesLoader.downloadFile(metaFile, metaFileUrl);
            if (!metaFileMD5.exists()) {
                throw new RuntimeException("Failed to download " + metaFileUrl);
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(metaFile);
        return doc.getElementsByTagName(xmlTag).item(0).getFirstChild().getNodeValue();
    }

    static void loadLibraryClassMaven(String groupId, String artifactId, String version, String extra, String repo, File path) throws RuntimeException, IOException {
        String name = artifactId + "-" + version + ".jar";
        File saveLocation = new File(path, name);
        Utils.logger.info("Verifying " + name);
        if (!LibrariesLoader.downloadLibraryMaven(groupId, artifactId, version, extra, repo, saveLocation, true)) {
            throw new RuntimeException("Failed to download libraries!");
        }
        LibrariesLoader.loadLibraryClassLocal(saveLocation);
    }

    static void loadLibraryClassLocal(File file) throws MalformedURLException {
        Utils.logger.info("Loading library " + file);
        LOADER.get().addURL(file.toURI().toURL());
    }
}

