/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.internal;

import com.google.gson.JsonObject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.CloseableHttpResponse;
import me.dreamvoid.miraimc.libraries.org.apache.http.client.methods.HttpPost;
import me.dreamvoid.miraimc.libraries.org.apache.http.entity.StringEntity;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.client.CloseableHttpClient;
import me.dreamvoid.miraimc.libraries.org.apache.http.impl.client.HttpClients;
import me.dreamvoid.miraimc.libraries.org.apache.http.message.BasicHeader;

public final class Utils {
    public static Logger logger;
    public static ClassLoader classLoader;
    public static Connection connection;
    public static HikariDataSource ds;

    public static void setLogger(Logger logger) {
        Utils.logger = logger;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        Utils.classLoader = classLoader;
    }

    public static void initializeSQLite() throws SQLException, ClassNotFoundException {
        Class.forName("org.sqlite.JDBC");
        connection = DriverManager.getConnection("jdbc:sqlite:" + new File(Config.PluginDir, "database.db").getPath());
    }

    public static void closeSQLite() throws SQLException {
        connection.close();
    }

    public static void initializeMySQL() {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("com.mysql.jdbc.Driver");
        config.setJdbcUrl("jdbc:mysql://" + Config.Database.MySQL.Address + "/" + Config.Database.MySQL.Database);
        config.setUsername(Config.Database.MySQL.Username);
        config.setPassword(Config.Database.MySQL.Password);
        config.setConnectionTimeout((long)Config.Database.MySQL.Poll.ConnectionTimeout);
        config.setIdleTimeout((long)Config.Database.MySQL.Poll.IdleTimeout);
        config.setMaxLifetime((long)Config.Database.MySQL.Poll.MaxLifetime);
        config.setMaximumPoolSize(Config.Database.MySQL.Poll.MaximumPoolSize);
        config.setKeepaliveTime((long)Config.Database.MySQL.Poll.KeepaliveTime);
        config.setMinimumIdle(Config.Database.MySQL.Poll.MinimumIdle);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        ds = new HikariDataSource(config);
    }

    public static void closeMySQL() {
        ds.close();
    }

    public static final class Http {
        public static String get(String url) throws IOException {
            URL obj = new URL(url);
            StringBuilder sb = new StringBuilder();
            HttpURLConnection httpUrlConn = (HttpURLConnection)obj.openConnection();
            httpUrlConn.setDoInput(true);
            httpUrlConn.setRequestMethod("GET");
            httpUrlConn.setRequestProperty("User-Agent", "Mozilla/5.0 DreamVoid MiraiMC");
            httpUrlConn.setConnectTimeout(5000);
            httpUrlConn.setReadTimeout(10000);
            InputStream input = httpUrlConn.getInputStream();
            InputStreamReader read = new InputStreamReader(input, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(read);
            String data = br.readLine();
            while (data != null) {
                sb.append(data);
                data = br.readLine();
            }
            br.close();
            read.close();
            input.close();
            httpUrlConn.disconnect();
            return sb.toString();
        }

        public static String post(JsonObject json, String URL2) throws IOException {
            try (CloseableHttpClient client = HttpClients.createDefault();){
                String line;
                HttpPost post = new HttpPost(URL2);
                post.setHeader("Content-Type", "application/json");
                post.addHeader("Authorization", "Basic YWRtaW46");
                StringEntity s = new StringEntity(json.toString(), StandardCharsets.UTF_8);
                s.setContentType(new BasicHeader("Content-Type", "application/json"));
                post.setEntity(s);
                CloseableHttpResponse httpResponse = client.execute(post);
                InputStream inStream = httpResponse.getEntity().getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));
                StringBuilder strber = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    strber.append(line).append("\n");
                }
                inStream.close();
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    logger.warning("Http request returned bad status code: " + httpResponse.getStatusLine().getStatusCode() + ", reason: " + httpResponse.getStatusLine().getReasonPhrase());
                }
                String string = strber.toString();
                return string;
            }
        }
    }
}

