/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.api.bot;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import me.dreamvoid.miraimc.api.bot.group.MiraiNormalMember;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MusicKind;
import net.mamoe.mirai.message.data.MusicShare;
import net.mamoe.mirai.utils.ExternalResource;

public class MiraiGroup {
    private final Group group;

    public MiraiGroup(Bot bot, long groupID) throws NullPointerException {
        this.group = bot.getGroup(groupID);
    }

    public MiraiNormalMember getMember(long memberAccount) {
        return new MiraiNormalMember(this.group, memberAccount);
    }

    public void sendMessage(String message) {
        this.group.sendMessage(message);
    }

    public void sendMessageMirai(String message) {
        this.group.sendMessage((Message)MiraiCode.deserializeMiraiCode((String)message));
    }

    public boolean contains(long memberAccount) {
        return this.group.contains(memberAccount);
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String name) {
        this.group.setName(name);
    }

    public boolean doQuit() {
        return this.group.quit();
    }

    public int getBotPermission() {
        return this.group.getBotPermission().getLevel();
    }

    public String uploadImage(File imageFile) {
        Image i = ExternalResource.uploadAsImage((File)imageFile, (Contact)this.group);
        return i.getImageId();
    }

    public boolean isBotMuted() {
        return this.group.getBotAsMember().isMuted();
    }

    public int getBotMuteTimeRemaining() {
        return this.group.getBotMuteRemaining();
    }

    public boolean isImageEmoji(String ImageID) {
        return Image.fromId((String)ImageID).isEmoji();
    }

    public boolean isAnonymousChatEnabled() {
        return this.group.getSettings().isAnonymousChatEnabled();
    }

    public void isAnonymousChatEnabled(boolean enable) {
        this.group.getSettings().setAnonymousChatEnabled(enable);
    }

    public void sendMusicShare(String Kind2, String Title, String Summary, String JumpUrl, String PictureUrl, String MusicUrl) {
        this.group.sendMessage((Message)new MusicShare(MusicKind.valueOf((String)Kind2), Title, Summary, JumpUrl, PictureUrl, MusicUrl));
    }

    public List<MiraiNormalMember> getMembers() {
        return this.group.getMembers().stream().map(member -> new MiraiNormalMember(this.group, member.getId())).collect(Collectors.toList());
    }
}

