/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.dreamvoid.miraimc.api.bot.MiraiFriend;
import me.dreamvoid.miraimc.api.bot.MiraiGroup;
import me.dreamvoid.miraimc.api.bot.MiraiOtherClient;
import me.dreamvoid.miraimc.internal.Config;
import me.dreamvoid.miraimc.internal.MiraiLoginSolver;
import me.dreamvoid.miraimc.internal.Utils;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.BotFactory;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.contact.Stranger;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.ExternalResource;
import net.mamoe.mirai.utils.LoggerAdapters;

public class MiraiBot {
    private final Bot bot;
    private static Logger logger;

    private MiraiBot(long BotAccount) throws NoSuchElementException {
        logger = Utils.logger;
        this.bot = Bot.getInstance((long)BotAccount);
    }

    private MiraiBot(Bot Bot2) {
        logger = Utils.logger;
        this.bot = Bot2;
    }

    public static MiraiBot asBot(Bot Bot2) {
        return new MiraiBot(Bot2);
    }

    public static MiraiBot getBot(long BotAccount) throws NoSuchElementException {
        return new MiraiBot(BotAccount);
    }

    public static List<String> getAvailableProtocol() {
        return MiraiBot.getAvailableProtocol(false);
    }

    public static List<String> getAvailableProtocol(boolean AddHttpAPI) {
        List<String> result = Arrays.stream(BotConfiguration.MiraiProtocol.values()).map(Enum::name).collect(Collectors.toList());
        if (AddHttpAPI) {
            result.add("HTTPAPI");
        }
        return result;
    }

    public static List<Long> getOnlineBots() {
        ArrayList<Long> BotList = new ArrayList<Long>();
        for (Bot bot : Bot.getInstances()) {
            BotList.add(bot.getId());
        }
        return BotList;
    }

    public MiraiFriend getFriend(long FriendAccount) {
        return new MiraiFriend(this.bot, FriendAccount);
    }

    public MiraiGroup getGroup(long GroupID) {
        return new MiraiGroup(this.bot, GroupID);
    }

    public static void doBotLogin(long Account, byte[] PasswordMD5, BotConfiguration.MiraiProtocol Protocol) {
        MiraiBot.login(Account, PasswordMD5, Protocol);
    }

    public static void doBotLogin(long Account, String Password2, String Protocol) throws IllegalArgumentException {
        MiraiBot.doBotLogin(Account, Password2, BotConfiguration.MiraiProtocol.valueOf((String)Protocol));
    }

    public static void doBotLogin(long Account, byte[] PasswordMD5, String Protocol) throws IllegalArgumentException {
        MiraiBot.doBotLogin(Account, PasswordMD5, BotConfiguration.MiraiProtocol.valueOf((String)Protocol));
    }

    public static void doBotLogin(long Account, String Password2, BotConfiguration.MiraiProtocol Protocol) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(Password2.getBytes(StandardCharsets.UTF_8));
            byte[] md5 = m.digest();
            MiraiBot.doBotLogin(Account, md5, Protocol);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("\u52a0\u5bc6\u5bc6\u7801\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e);
        }
    }

    public void doOnline() {
        this.bot.join();
    }

    @Deprecated
    public void doLogout() {
        this.bot.close();
    }

    public void close() {
        this.bot.close();
    }

    public boolean isOnline() {
        return this.bot.isOnline();
    }

    public boolean isExist() {
        return !Objects.equals(this.bot, null);
    }

    public String getNick() {
        return this.bot.getNick();
    }

    public long getID() {
        return this.bot.getId();
    }

    public List<Long> getFriendList() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Friend friend : this.bot.getFriends()) {
            result.add(friend.getId());
        }
        return result;
    }

    public List<Long> getGroupList() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Group group : this.bot.getGroups()) {
            result.add(group.getId());
        }
        return result;
    }

    public List<Long> getStrangersList() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Stranger stranger : this.bot.getStrangers()) {
            result.add(stranger.getId());
        }
        return result;
    }

    public MiraiFriend getAsFriend() {
        return new MiraiFriend(this.bot.getBot(), this.bot.getId());
    }

    public String uploadImage(File image) {
        return this.bot.getAsFriend().uploadImage(ExternalResource.create((File)image).toAutoCloseable()).getImageId();
    }

    public MiraiOtherClient getOtherClient(long OtherClient2) throws NoSuchElementException {
        return new MiraiOtherClient((OtherClient)this.bot.getOtherClients().getOrFail(OtherClient2));
    }

    public List<MiraiOtherClient> getOtherClients() {
        return this.bot.getOtherClients().stream().map(MiraiOtherClient::new).collect(Collectors.toList());
    }

    private static void login(long Account, byte[] Password2, final BotConfiguration.MiraiProtocol Protocol) {
        logger = Utils.logger;
        Bot existBot = Bot.getInstanceOrNull((long)Account);
        if (existBot != null) {
            logger.info("\u53e6\u4e00\u4e2a\u673a\u5668\u4eba\u8fdb\u7a0b\u5df2\u7ecf\u5b58\u5728\uff0c\u6b63\u5728\u5c1d\u8bd5\u5173\u95ed\u8fd9\u4e2a\u8fdb\u7a0b");
            MiraiLoginSolver.cancel(Account);
            existBot.close();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.info("\u767b\u5f55\u65b0\u7684\u673a\u5668\u4eba\u8d26\u53f7: " + Account + ", \u534f\u8bae: " + Protocol.name());
        File MiraiDir = !Config.General.MiraiWorkingDir.equals("default") ? new File(Config.General.MiraiWorkingDir) : new File(Config.PluginDir, "MiraiBot");
        final File BotConfig = new File(new File(MiraiDir, "bots"), String.valueOf(Account));
        if (!BotConfig.exists() && !BotConfig.mkdirs()) {
            throw new RuntimeException("Failed to create folder " + BotConfig.getPath());
        }
        Bot bot = BotFactory.INSTANCE.newBot(Account, Password2, new BotConfiguration(){
            {
                this.setProtocol(Protocol);
                this.setWorkingDir(BotConfig);
                this.fileBasedDeviceInfo();
                if (Config.Bot.DisableNetworkLogs) {
                    this.noNetworkLog();
                } else if (Config.Bot.UseMinecraftLogger.NetworkLogs) {
                    this.setNetworkLoggerSupplier(bot -> LoggerAdapters.asMiraiLogger((Logger)logger));
                }
                if (Config.Bot.DisableBotLogs) {
                    this.noBotLog();
                } else if (Config.Bot.UseMinecraftLogger.BotLogs) {
                    this.setBotLoggerSupplier(bot -> LoggerAdapters.asMiraiLogger((Logger)logger));
                }
                this.getContactListCache().setFriendListCacheEnabled(Config.Bot.ContactCache.EnableFriendListCache);
                this.getContactListCache().setGroupMemberListCacheEnabled(Config.Bot.ContactCache.EnableGroupMemberListCache);
                this.getContactListCache().setSaveIntervalMillis(Config.Bot.ContactCache.SaveIntervalMillis);
                this.setLoginSolver(new MiraiLoginSolver());
            }
        });
        try {
            bot.login();
            logger.info(bot.getNick() + "(" + bot.getId() + ") \u767b\u5f55\u6210\u529f");
        }
        catch (Exception e) {
            logger.warning("\u767b\u5f55\u673a\u5668\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0: " + e.getLocalizedMessage());
        }
    }
}

