/*
 * Decompiled with CFR 0.152.
 */
package me.dreamvoid.miraimc.httpapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.dreamvoid.miraimc.httpapi.exception.AbnormalStatusException;
import me.dreamvoid.miraimc.httpapi.response.Bind;
import me.dreamvoid.miraimc.httpapi.response.FetchMessage;
import me.dreamvoid.miraimc.httpapi.response.Release;
import me.dreamvoid.miraimc.httpapi.response.SendMessage;
import me.dreamvoid.miraimc.httpapi.response.Verify;
import me.dreamvoid.miraimc.internal.Utils;

public class MiraiHttpAPI {
    public static MiraiHttpAPI INSTANCE;
    private final String url;
    private final Gson gson = new Gson();
    public static final HashMap<Long, String> Bots;

    public MiraiHttpAPI(String url) {
        this.url = url;
        INSTANCE = this;
    }

    public Verify verify(String verifyKey) throws IOException, AbnormalStatusException {
        JsonObject json = new JsonObject();
        json.addProperty("verifyKey", verifyKey);
        Verify verify = (Verify)this.gson.fromJson(Utils.Http.post(json, this.url + "/verify"), Verify.class);
        if (verify.code != 0) {
            throw new AbnormalStatusException(verify.code, verify.msg);
        }
        return verify;
    }

    public Bind bind(String sessionKey, long qq) throws IOException, AbnormalStatusException {
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("qq", (Number)qq);
        Bind bind = (Bind)this.gson.fromJson(Utils.Http.post(json, this.url + "/bind"), Bind.class);
        if (bind.code != 0) {
            throw new AbnormalStatusException(bind.code, bind.msg);
        }
        Bots.put(qq, sessionKey);
        return bind;
    }

    public Release release(String sessionKey, long qq) throws IOException, AbnormalStatusException {
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("qq", (Number)qq);
        Release release = (Release)this.gson.fromJson(Utils.Http.post(json, this.url + "/release"), Release.class);
        if (release.code != 0) {
            throw new AbnormalStatusException(release.code, release.msg);
        }
        Bots.remove(qq);
        return release;
    }

    public SendMessage sendFriendMessage(String sessionKey, long target, String message) throws IOException, AbnormalStatusException {
        FetchMessage.Data.MessageChain chain = new FetchMessage.Data.MessageChain();
        chain.text = message;
        JsonArray messageArray = this.gson.toJsonTree(Collections.singletonList(chain), new TypeToken<List<FetchMessage.Data.MessageChain>>(){}.getType()).getAsJsonArray();
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("target", (Number)target);
        json.add("messageChain", (JsonElement)messageArray);
        SendMessage sendMessage = (SendMessage)this.gson.fromJson(Utils.Http.post(json, this.url + "/sendFriendMessage"), SendMessage.class);
        if (sendMessage.code != 0) {
            throw new AbnormalStatusException(sendMessage.code, sendMessage.msg);
        }
        return sendMessage;
    }

    public SendMessage sendFriendMessage(String sessionKey, long target, FetchMessage.Data.MessageChain[] messageChain) throws IOException, AbnormalStatusException {
        JsonArray messageArray = this.gson.toJsonTree((Object)messageChain, new TypeToken<List<FetchMessage.Data.MessageChain>>(){}.getType()).getAsJsonArray();
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("target", (Number)target);
        json.add("messageChain", (JsonElement)messageArray);
        SendMessage sendMessage = (SendMessage)this.gson.fromJson(Utils.Http.post(json, this.url + "/sendFriendMessage"), SendMessage.class);
        if (sendMessage.code != 0) {
            throw new AbnormalStatusException(sendMessage.code, sendMessage.msg);
        }
        return sendMessage;
    }

    public SendMessage sendGroupMessage(String sessionKey, long target, String message) throws IOException, AbnormalStatusException {
        FetchMessage.Data.MessageChain chain = new FetchMessage.Data.MessageChain();
        chain.text = message;
        JsonArray messageArray = this.gson.toJsonTree(Collections.singletonList(chain), new TypeToken<List<FetchMessage.Data.MessageChain>>(){}.getType()).getAsJsonArray();
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("target", (Number)target);
        json.add("messageChain", (JsonElement)messageArray);
        SendMessage sendMessage = (SendMessage)this.gson.fromJson(Utils.Http.post(json, this.url + "/sendGroupMessage"), SendMessage.class);
        if (sendMessage.code != 0) {
            throw new AbnormalStatusException(sendMessage.code, sendMessage.msg);
        }
        return sendMessage;
    }

    public SendMessage sendGroupMessage(String sessionKey, long target, FetchMessage.Data.MessageChain[] messageChain) throws IOException, AbnormalStatusException {
        JsonArray messageArray = this.gson.toJsonTree((Object)messageChain, new TypeToken<List<FetchMessage.Data.MessageChain>>(){}.getType()).getAsJsonArray();
        JsonObject json = new JsonObject();
        json.addProperty("sessionKey", sessionKey);
        json.addProperty("target", (Number)target);
        json.add("messageChain", (JsonElement)messageArray);
        SendMessage sendMessage = (SendMessage)this.gson.fromJson(Utils.Http.post(json, this.url + "/sendGroupMessage"), SendMessage.class);
        if (sendMessage.code != 0) {
            throw new AbnormalStatusException(sendMessage.code, sendMessage.msg);
        }
        return sendMessage;
    }

    public FetchMessage fetchMessage(String sessionKey, int count) throws IOException {
        FetchMessage fetchMessage = (FetchMessage)this.gson.fromJson(Utils.Http.get(this.url + "/fetchMessage?sessionKey=" + sessionKey + "&count=" + count), FetchMessage.class);
        if (fetchMessage.code != 0) {
            throw new AbnormalStatusException(fetchMessage.code, fetchMessage.msg);
        }
        return fetchMessage;
    }

    static {
        Bots = new HashMap();
    }
}

