/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.util;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Throwables2;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Predicates2 {
    public static final long DEFAULT_PERIOD = 50L;
    public static final long DEFAULT_MAX_PERIOD = 1000L;

    public static Predicate<String> startsWith(final String prefix) {
        return new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return input.startsWith(prefix);
            }

            public String toString() {
                return "startsWith(" + prefix + ")";
            }
        };
    }

    public static <T> Predicate<T> retry(Predicate<T> findOrBreak, long timeout, long period, long maxPeriod, TimeUnit unit) {
        return new RetryablePredicate<T>(findOrBreak, timeout, period, maxPeriod, unit);
    }

    public static <T> Predicate<T> retry(Predicate<T> findOrBreak, long timeout, long period, TimeUnit unit) {
        return Predicates2.retry(findOrBreak, timeout, period, period * 10L, unit);
    }

    public static <T> Predicate<T> retry(Predicate<T> findOrBreak, long timeout, long period, long maxPeriod) {
        return Predicates2.retry(findOrBreak, timeout, period, maxPeriod, TimeUnit.MILLISECONDS);
    }

    public static <T> Predicate<T> retry(Predicate<T> findOrBreak, long timeout) {
        return Predicates2.retry(findOrBreak, timeout, 50L, 1000L, TimeUnit.MILLISECONDS);
    }

    private static class RetryablePredicate<T>
    implements Predicate<T> {
        private final long timeout;
        private final long period;
        private final long maxPeriod;
        private final Predicate<T> findOrBreak;
        @Resource
        protected Logger logger = Logger.NULL;

        protected RetryablePredicate(Predicate<T> findOrBreak, long timeout, long period, long maxPeriod, TimeUnit unit) {
            this.findOrBreak = findOrBreak;
            this.timeout = unit.toMillis(timeout);
            this.period = unit.toMillis(period);
            this.maxPeriod = unit.toMillis(maxPeriod);
        }

        @Override
        public boolean apply(T input) {
            try {
                long i = 1L;
                long now = System.currentTimeMillis();
                long end = now + this.timeout;
                while (now < end) {
                    long sleepTime;
                    if (this.findOrBreak.apply(input)) {
                        return true;
                    }
                    if ((sleepTime = this.nextMaxInterval(i++, end)) > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    now = System.currentTimeMillis();
                }
                return this.findOrBreak.apply(input);
            }
            catch (InterruptedException e) {
                this.logger.warn(e, "predicate %s on %s interrupted, returning false", input, this.findOrBreak);
                Thread.currentThread().interrupt();
                return false;
            }
            catch (RuntimeException e) {
                if (Throwables2.getFirstThrowableOfType(e, ExecutionException.class) != null) {
                    this.logger.warn(e, "predicate %s on %s errored [%s], returning false", input, this.findOrBreak, e.getMessage());
                    return false;
                }
                if (Throwables2.getFirstThrowableOfType(e, IllegalStateException.class) != null) {
                    this.logger.warn(e, "predicate %s on %s illegal state [%s], returning false", input, this.findOrBreak, e.getMessage());
                    return false;
                }
                if (Throwables2.getFirstThrowableOfType(e, CancellationException.class) != null) {
                    this.logger.warn(e, "predicate %s on %s cancelled [%s], returning false", input, this.findOrBreak, e.getMessage());
                    return false;
                }
                if (Throwables2.getFirstThrowableOfType(e, TimeoutException.class) != null) {
                    this.logger.warn(e, "predicate %s on %s timed out [%s], returning false", input, this.findOrBreak, e.getMessage());
                    return false;
                }
                throw e;
            }
        }

        @Deprecated
        protected long nextMaxInterval(long attempt, Date end) {
            return this.nextMaxInterval(attempt, end.getTime());
        }

        protected long nextMaxInterval(long attempt, long endTime) {
            long interval = (long)((double)this.period * Math.pow(1.5, attempt - 1L));
            interval = interval > this.maxPeriod ? this.maxPeriod : interval;
            long max = endTime - System.currentTimeMillis();
            return interval > max ? max : interval;
        }

        @Deprecated
        protected boolean before(Date end) {
            return new Date().compareTo(end) < 0;
        }

        @Deprecated
        protected boolean atOrAfter(Date end) {
            return new Date().compareTo(end) >= 0;
        }
    }
}

