/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.binders;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.Json;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.MapBinder;
import java.util.Map;

public class BindToJsonPayload
implements MapBinder {
    protected final Json jsonBinder;

    @Inject
    public BindToJsonPayload(Json jsonBinder) {
        this.jsonBinder = Preconditions.checkNotNull(jsonBinder, "jsonBinder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        return this.bindToRequest(request, (Object)postParams);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String json = this.jsonBinder.toJson(Preconditions.checkNotNull(payload, "payload"));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

