/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Objects;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.Invokable;
import java.util.List;

@Beta
public final class Invocation {
    private final Invokable<?, ?> invokable;
    private final List<Object> args;

    public static Invocation create(Invokable<?, ?> invokable, List<Object> args) {
        return new Invocation(invokable, args);
    }

    public static Invocation create(Invokable<?, ?> invokable) {
        Preconditions.checkArgument(invokable.getParameters().isEmpty() || invokable.getParameters().size() == 1 && invokable.isVarArgs(), "please specify arguments to %s", invokable);
        return Invocation.create(invokable, ImmutableList.of());
    }

    private Invocation(Invokable<?, ?> invokable, List<Object> args) {
        this.invokable = Preconditions.checkNotNull(invokable, "invokable");
        this.args = Preconditions.checkNotNull(args, "args");
    }

    public Invokable<?, ?> getInvokable() {
        return this.invokable;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invocation that = (Invocation)Invocation.class.cast(o);
        return Objects.equal(this.invokable, that.invokable) && Objects.equal(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hashCode(this.invokable, this.args);
    }

    public String toString() {
        return String.format("%s%s", this.invokable, this.args);
    }
}

