/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging;

import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;

public abstract class BaseLogger
implements Logger {
    protected abstract void logError(String var1, Throwable var2);

    protected abstract void logError(String var1);

    protected abstract void logWarn(String var1, Throwable var2);

    protected abstract void logWarn(String var1);

    protected abstract void logInfo(String var1);

    protected abstract void logDebug(String var1);

    protected abstract void logTrace(String var1);

    @Override
    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logTrace(this.formatIfArgs(message, args));
        }
    }

    private String formatIfArgs(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logDebug(this.formatIfArgs(message, args));
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logInfo(this.formatIfArgs(message, args));
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.logWarn(this.formatIfArgs(message, args));
        }
    }

    @Override
    public void warn(Throwable e, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.logWarn(this.formatIfArgs(message, args), e);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.logError(this.formatIfArgs(message, args));
        }
    }

    @Override
    public void error(Throwable e, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.logError(this.formatIfArgs(message, args), e);
        }
    }
}

