/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.fromconfig;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Splitter;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.assistedinject.Assisted;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.config.ValueOfConfigurationKeyOrNull;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.util.Set;

@Singleton
public class SplitConfigurationKey
implements Supplier<Set<String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ValueOfConfigurationKeyOrNull config;
    protected final String provider;
    protected final String configKey;

    public SplitConfigurationKey(ValueOfConfigurationKeyOrNull config, @Provider String provider, @Assisted String configKey) {
        this.config = config;
        this.provider = provider;
        this.configKey = configKey;
    }

    @Override
    public Set<String> get() {
        String regionString = this.config.apply(this.configKey);
        if (regionString == null) {
            this.logger.debug("no %s configured for provider %s", this.configKey, this.provider);
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(Splitter.on(',').split(regionString));
    }

    public String toString() {
        return "splitConfigurationKey(" + this.configKey + ")";
    }
}

