/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.suppliers.fromconfig;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Supplier;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Suppliers;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.assistedinject.Assisted;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.config.ValueOfConfigurationKeyOrNull;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.location.Provider;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.net.URI;
import java.util.Map;
import java.util.Set;

public class LocationIdToURIFromConfigurationOrDefaultToProvider
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ValueOfConfigurationKeyOrNull config;
    protected final Supplier<Set<String>> locationIds;
    protected final Supplier<URI> providerURI;
    protected final String configPrefix;

    @Inject
    public LocationIdToURIFromConfigurationOrDefaultToProvider(ValueOfConfigurationKeyOrNull config, @Provider Supplier<URI> providerURI, @Assisted Supplier<Set<String>> locationIds, @Assisted String configPrefix) {
        this.config = config;
        this.locationIds = locationIds;
        this.providerURI = providerURI;
        this.configPrefix = configPrefix;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        ImmutableMap.Builder<String, Supplier<URI>> locations = ImmutableMap.builder();
        for (String location : this.locationIds.get()) {
            String configKey = this.configPrefix + "." + location + "." + "endpoint";
            String locationUri = this.config.apply(configKey);
            if (locationUri == null) {
                this.logger.debug("config key %s not present, defaulting to %s", configKey, this.providerURI);
                locations.put(location, this.providerURI);
                continue;
            }
            locations.put(location, Suppliers.ofInstance(URI.create(locationUri)));
        }
        return locations.build();
    }
}

