/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.handlers;

import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpCommand;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpErrorHandler;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpUtils;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;

@Singleton
public class CloseContentAndSetExceptionErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse from) {
        try {
            String content = from.getPayload() != null ? Strings2.toStringAndClose(from.getPayload().openStream()) : null;
            command.setException(new HttpResponseException(command, from, content));
        }
        catch (IOException e) {
            command.setException(new HttpResponseException(command, from));
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }
}

