/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.handlers;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Named;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpCommand;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRetryHandler;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.IOExceptionRetryHandler;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import java.io.IOException;
import java.util.Random;

@Singleton
public class BackoffLimitedRetryHandler
implements HttpRetryHandler,
IOExceptionRetryHandler {
    public static final BackoffLimitedRetryHandler INSTANCE = new BackoffLimitedRetryHandler();
    @Inject(optional=true)
    @Named(value="jclouds.max-retries")
    private int retryCountLimit = 5;
    @Inject(optional=true)
    @Named(value="jclouds.retries-delay-start")
    private long delayStart = 50L;
    @Resource
    protected Logger logger = Logger.NULL;

    @Override
    public boolean shouldRetryRequest(HttpCommand command, IOException error) {
        return this.ifReplayableBackoffAndReturnTrue(command);
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        return this.ifReplayableBackoffAndReturnTrue(command);
    }

    private boolean ifReplayableBackoffAndReturnTrue(HttpCommand command) {
        command.incrementFailureCount();
        if (!command.isReplayable()) {
            this.logger.error("Cannot retry after server error, command is not replayable: %1$s", command);
            return false;
        }
        if (command.getFailureCount() > this.retryCountLimit) {
            this.logger.error("Cannot retry after server error, command has exceeded retry limit %1$d: %2$s", this.retryCountLimit, command);
            return false;
        }
        this.imposeBackoffExponentialDelay(command.getFailureCount(), "server error: " + command.toString());
        return true;
    }

    public void imposeBackoffExponentialDelay(int failureCount, String commandDescription) {
        this.imposeBackoffExponentialDelay(this.delayStart, 2, failureCount, this.retryCountLimit, commandDescription);
    }

    public void imposeBackoffExponentialDelay(long period, int pow, int failureCount, int max, String commandDescription) {
        this.imposeBackoffExponentialDelay(period, period * 10L, pow, failureCount, max, commandDescription);
    }

    public void imposeBackoffExponentialDelay(long period, long maxPeriod, int pow, int failureCount, int max, String commandDescription) {
        if (period == 0L) {
            this.logger.debug("Retry %d/%d: delaying for %d ms: %s", failureCount, max, 0, commandDescription);
            return;
        }
        long delayMs = (long)((double)period * Math.pow(failureCount, pow));
        delayMs = (delayMs += (long)new Random().nextInt((int)Math.max(delayMs / 10L, 1L))) > maxPeriod ? maxPeriod : delayMs;
        this.logger.debug("Retry %d/%d: delaying for %d ms: %s", failureCount, max, delayMs, commandDescription);
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            Throwables.propagate(e);
        }
    }
}

