/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.functions;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableList;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.util.concurrent.Atomics;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.stream.JsonReader;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.stream.JsonToken;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.javax.annotation.Resource;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.json.internal.GsonWrapper;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.logging.Logger;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Closeables2;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ParseFirstJsonValueNamed<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final GsonWrapper json;
    private final TypeLiteral<T> type;
    private final ImmutableSet<String> nameChoices;

    public ParseFirstJsonValueNamed(GsonWrapper json, TypeLiteral<T> type, String ... nameChoices) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.type = Preconditions.checkNotNull(type, "type");
        this.nameChoices = ImmutableSet.copyOf(Preconditions.checkNotNull(nameChoices, "nameChoices"));
    }

    @Override
    public T apply(HttpResponse arg0) {
        T t;
        JsonReader reader;
        block9: {
            AtomicReference<String> name;
            block8: {
                if (arg0.getPayload() == null) {
                    return this.nothing();
                }
                reader = null;
                reader = new JsonReader(new InputStreamReader(arg0.getPayload().getInput()));
                reader.setLenient(true);
                name = Atomics.newReference();
                JsonToken token = reader.peek();
                while (token != JsonToken.END_DOCUMENT && this.nnn(reader, token, name)) {
                    token = this.skipAndPeek(token, reader);
                }
                if (name.get() != null) break block8;
                this.logger.trace("did not object named %s in json from response %s", this.nameChoices, arg0);
                T t2 = this.nothing();
                Closeables2.closeQuietly(reader);
                arg0.getPayload().release();
                return t2;
            }
            if (!this.nameChoices.contains(name.get())) break block9;
            Object t3 = this.json.delegate().fromJson(reader, this.type.getType());
            Closeables2.closeQuietly(reader);
            arg0.getPayload().release();
            return t3;
        }
        try {
            t = this.nothing();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(String.format("error reading from stream, parsing object named %s from http response %s", this.nameChoices, arg0), e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(reader);
                arg0.getPayload().release();
                throw throwable;
            }
        }
        Closeables2.closeQuietly(reader);
        arg0.getPayload().release();
        return t;
    }

    private T nothing() {
        if (this.type.getRawType().isAssignableFrom(Set.class)) {
            return (T)ImmutableSet.of();
        }
        if (this.type.getRawType().isAssignableFrom(List.class)) {
            return (T)ImmutableList.of();
        }
        if (this.type.getRawType().isAssignableFrom(Map.class)) {
            return (T)ImmutableMap.of();
        }
        return null;
    }

    private boolean nnn(JsonReader reader, JsonToken token, AtomicReference<String> name) throws IOException {
        String name2;
        if (token == JsonToken.NAME && this.nameChoices.contains(name2 = reader.nextName())) {
            name.set(name2);
            return false;
        }
        return true;
    }

    private JsonToken skipAndPeek(JsonToken token, JsonReader reader) throws IOException {
        switch (token) {
            case BEGIN_ARRAY: {
                reader.beginArray();
                break;
            }
            case END_ARRAY: {
                reader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                reader.beginObject();
                break;
            }
            case END_OBJECT: {
                reader.endObject();
                break;
            }
            case NAME: {
                break;
            }
            case STRING: {
                reader.nextString();
                break;
            }
            case NUMBER: {
                reader.nextString();
                break;
            }
            case BOOLEAN: {
                reader.nextBoolean();
                break;
            }
            case NULL: {
                reader.nextNull();
                break;
            }
        }
        return reader.peek();
    }
}

