/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.fallbacks;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.Fallback;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.fallbacks.PropagateIfRetryAfter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceNotFoundException;

@Singleton
public final class MapHttp4xxCodesToExceptions
implements Fallback<Object> {
    private final PropagateIfRetryAfter propagateIfRetryAfter;

    @Inject
    MapHttp4xxCodesToExceptions(PropagateIfRetryAfter propagateIfRetryAfter) {
        this.propagateIfRetryAfter = Preconditions.checkNotNull(propagateIfRetryAfter, "propagateIfRetryAfter");
    }

    @Override
    public Object createOrPropagate(Throwable t) throws Exception {
        HttpResponseException responseException;
        this.propagateIfRetryAfter.createOrPropagate(t);
        if (t instanceof HttpResponseException && (responseException = (HttpResponseException)HttpResponseException.class.cast(t)).getResponse() != null) {
            switch (responseException.getResponse().getStatusCode()) {
                case 401: {
                    throw new AuthorizationException(responseException);
                }
                case 403: {
                    throw new AuthorizationException(responseException);
                }
                case 404: {
                    throw new ResourceNotFoundException(responseException);
                }
                case 409: {
                    throw new IllegalStateException(responseException);
                }
            }
        }
        throw Throwables.propagate(t);
    }
}

