/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.fallbacks;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.annotations.Beta;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Optional;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Ticker;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.date.DateCodec;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.date.DateCodecFactory;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.fallbacks.PropagateIfRetryAfter;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.RetryAfterException;
import java.util.concurrent.TimeUnit;

@Beta
public final class HeaderToRetryAfterException
implements PropagateIfRetryAfter {
    private final Ticker ticker;
    private final DateCodec dateCodec;

    public static HeaderToRetryAfterException create(Ticker ticker, DateCodec dateCodec) {
        return new HeaderToRetryAfterException(ticker, dateCodec);
    }

    @Inject
    private HeaderToRetryAfterException(DateCodecFactory factory) {
        this(Ticker.systemTicker(), factory.rfc822());
    }

    private HeaderToRetryAfterException(Ticker ticker, DateCodec dateCodec) {
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        this.dateCodec = Preconditions.checkNotNull(dateCodec, "dateCodec");
    }

    @Override
    public Object createOrPropagate(Throwable t) throws Exception {
        Optional<RetryAfterException> retryException;
        if (!(t instanceof HttpResponseException)) {
            throw Throwables.propagate(t);
        }
        HttpResponse response = ((HttpResponseException)HttpResponseException.class.cast(t)).getResponse();
        if (response == null) {
            return null;
        }
        String retryAfter = response.getFirstHeaderOrNull("Retry-After");
        if (retryAfter != null && (retryException = this.tryCreateRetryAfterException(t, retryAfter)).isPresent()) {
            throw retryException.get();
        }
        return null;
    }

    public Optional<RetryAfterException> tryCreateRetryAfterException(Throwable in, String retryAfter) {
        Preconditions.checkNotNull(in, "throwable");
        Preconditions.checkNotNull(retryAfter, "retryAfter");
        if (retryAfter.matches("^[0-9]+$")) {
            return Optional.of(new RetryAfterException(in, Integer.parseInt(retryAfter)));
        }
        try {
            long retryTimeMillis = this.dateCodec.toDate(retryAfter).getTime();
            long currentTimeMillis = TimeUnit.NANOSECONDS.toMillis(this.ticker.read());
            return Optional.of(new RetryAfterException(in, (int)TimeUnit.MILLISECONDS.toSeconds(retryTimeMillis - currentTimeMillis)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }
}

