/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableMap;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.domain.Location;
import java.net.URI;
import java.util.Map;

public abstract class ResourceMetadataBuilder<T extends Enum<T>> {
    protected String providerId;
    protected String name;
    protected Location location;
    protected URI uri;
    protected Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public ResourceMetadataBuilder<T> providerId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public ResourceMetadataBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public ResourceMetadataBuilder<T> location(Location location) {
        this.location = location;
        return this;
    }

    public ResourceMetadataBuilder<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ResourceMetadataBuilder<T> userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = ImmutableMap.copyOf(Preconditions.checkNotNull(userMetadata, "userMetadata"));
        return this;
    }
}

