/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Predicate;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Iterables;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.reflect.TypeToken;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.View;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiMetadata;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.apis.ApiPredicates;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.osgi.ApiRegistry;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.reflect.Reflection2;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.TypeTokenUtils;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public class Apis {
    public static Function<ApiMetadata, String> idFunction() {
        return IdFunction.INSTANCE;
    }

    private static Iterable<ApiMetadata> fromServiceLoader() {
        return ServiceLoader.load(ApiMetadata.class);
    }

    public static Iterable<ApiMetadata> all() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(Apis.fromServiceLoader())).addAll(ApiRegistry.fromRegistry())).build();
    }

    public static ApiMetadata withId(String id) throws NoSuchElementException {
        return Iterables.find(Apis.all(), ApiPredicates.id(id));
    }

    public static Iterable<ApiMetadata> contextAssignableFrom(TypeToken<?> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.contextAssignableFrom(type));
    }

    public static Iterable<ApiMetadata> viewableAs(TypeToken<? extends View> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.viewableAs(type));
    }

    public static Iterable<ApiMetadata> viewableAs(Class<? extends View> type) {
        return Iterables.filter(Apis.all(), ApiPredicates.viewableAs(Reflection2.typeToken(type)));
    }

    public static TypeToken<?> findView(ApiMetadata apiMetadata, final TypeToken<?> view) throws NoSuchElementException {
        Preconditions.checkNotNull(apiMetadata, "apiMetadata must be defined");
        Preconditions.checkNotNull(view, "context must be defined");
        return Iterables.find(apiMetadata.getViews(), new Predicate<TypeToken<?>>(){

            @Override
            public boolean apply(TypeToken<?> input) {
                return TypeTokenUtils.isSupertypeOf(view, input);
            }
        });
    }

    private static enum IdFunction implements Function<ApiMetadata, String>
    {
        INSTANCE;


        @Override
        public String apply(ApiMetadata input) {
            return input.getId();
        }
    }
}

