/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdancy.jenkins.rest.shaded.com.google.inject.assistedinject;

import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.ImmutableSet;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Maps;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.ConfigurationException;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.Key;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.TypeLiteral;
import io.github.cdancy.jenkins.rest.shaded.com.google.inject.spi.Message;
import java.util.Collections;
import java.util.Map;

class BindingCollector {
    private final Map<Key<?>, TypeLiteral<?>> bindings = Maps.newHashMap();

    BindingCollector() {
    }

    public BindingCollector addBinding(Key<?> key, TypeLiteral<?> target) {
        if (this.bindings.containsKey(key)) {
            throw new ConfigurationException(ImmutableSet.of(new Message("Only one implementation can be specified for " + key)));
        }
        this.bindings.put(key, target);
        return this;
    }

    public Map<Key<?>, TypeLiteral<?>> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BindingCollector && this.bindings.equals(((BindingCollector)obj).bindings);
    }
}

