/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import com.cdancy.jenkins.rest.domain.common.Error;
import com.cdancy.jenkins.rest.domain.common.IntegerResponse;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Function;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class LocationToQueueId
implements Function<HttpResponse, IntegerResponse> {
    private static final Pattern pattern = Pattern.compile("^.*/queue/item/(\\d+)/$");

    @Override
    public IntegerResponse apply(HttpResponse response) {
        Matcher matcher;
        if (response == null) {
            throw new RuntimeException("Unexpected NULL HttpResponse object");
        }
        String url = response.getFirstHeaderOrNull("Location");
        if (url != null && (matcher = pattern.matcher(url)).find() && matcher.groupCount() == 1) {
            return IntegerResponse.create(Integer.valueOf(matcher.group(1)), null);
        }
        Error error = Error.create(null, "No queue item Location header could be found despite getting a valid HTTP response.", NumberFormatException.class.getCanonicalName());
        return IntegerResponse.create(null, Lists.newArrayList(error));
    }
}

