/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.handlers;

import com.cdancy.jenkins.rest.exception.ForbiddenException;
import com.cdancy.jenkins.rest.exception.MethodNotAllowedException;
import com.cdancy.jenkins.rest.exception.RedirectTo404Exception;
import com.cdancy.jenkins.rest.exception.UnsupportedMediaTypeException;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Throwables;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpCommand;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpErrorHandler;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponse;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpResponseException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.AuthorizationException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceAlreadyExistsException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceNotFoundException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Closeables2;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.util.Strings2;
import java.io.IOException;

public class JenkinsErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        RuntimeException exception = null;
        try {
            String message = this.parseMessage(command, response);
            switch (response.getStatusCode()) {
                case 400: {
                    if (command.getCurrentRequest().getMethod().equals("POST") && command.getCurrentRequest().getRequestLine().contains("/createItem") && message.contains("A job already exists with the name")) {
                        exception = new ResourceAlreadyExistsException(message);
                        break;
                    }
                    exception = new IllegalArgumentException(message);
                    break;
                }
                case 401: {
                    exception = new AuthorizationException(message);
                    break;
                }
                case 403: {
                    exception = new ForbiddenException(message);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("POST")) {
                        String path = command.getCurrentRequest().getEndpoint().getPath();
                        if (path.endsWith("/term/")) {
                            exception = new RedirectTo404Exception("The term operation does not exist for " + command.getCurrentRequest().getEndpoint().toString() + ", try stop instead.");
                            break;
                        }
                        if (path.endsWith("/kill/")) {
                            exception = new RedirectTo404Exception("The kill operation does not exist for " + command.getCurrentRequest().getEndpoint().toString() + ", try stop instead.");
                            break;
                        }
                    }
                    exception = new ResourceNotFoundException(message);
                    break;
                }
                case 405: {
                    exception = new MethodNotAllowedException(message);
                    break;
                }
                case 409: {
                    exception = new ResourceAlreadyExistsException(message);
                    break;
                }
                case 415: {
                    exception = new UnsupportedMediaTypeException(message);
                    break;
                }
                default: {
                    exception = new HttpResponseException(command, response);
                }
            }
        }
        catch (Exception e) {
            try {
                exception = new HttpResponseException(command, response, e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(response.getPayload());
                command.setException(exception);
                throw throwable;
            }
            Closeables2.closeQuietly(response.getPayload());
            command.setException(exception);
        }
        Closeables2.closeQuietly(response.getPayload());
        command.setException(exception);
    }

    private String parseMessage(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose(response.getPayload().openStream());
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }
        String errorMessage = response.getFirstHeaderOrNull("X-Error");
        return command.getCurrentRequest().getRequestLine() + " -> " + response.getStatusLine() + " -> " + (errorMessage != null ? errorMessage : "");
    }
}

