/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.auth.AuthenticationType;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Inject;
import io.github.cdancy.jenkins.rest.shaded.javax.inject.Singleton;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequest;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.http.HttpRequestFilter;

@Singleton
public class JenkinsNoCrumbAuthenticationFilter
implements HttpRequestFilter {
    private final JenkinsAuthentication creds;

    @Inject
    JenkinsNoCrumbAuthenticationFilter(JenkinsAuthentication creds) {
        this.creds = creds;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        if (this.creds.authType() == AuthenticationType.Anonymous) {
            return request;
        }
        String authHeader = this.creds.authType().getAuthScheme() + " " + this.creds.authValue();
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", authHeader)).build();
    }
}

