/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.fallbacks;

import com.cdancy.jenkins.rest.domain.common.Error;
import com.cdancy.jenkins.rest.domain.common.IntegerResponse;
import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import com.cdancy.jenkins.rest.domain.plugins.Plugins;
import com.cdancy.jenkins.rest.domain.system.SystemInfo;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.base.Preconditions;
import io.github.cdancy.jenkins.rest.shaded.com.google.common.collect.Lists;
import io.github.cdancy.jenkins.rest.shaded.com.google.gson.JsonSyntaxException;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.Fallback;
import io.github.cdancy.jenkins.rest.shaded.org.jclouds.rest.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;

public final class JenkinsFallbacks {
    public static SystemInfo createSystemInfoFromErrors(List<Error> errors) {
        String illegalValue = "-1";
        return SystemInfo.create("-1", "-1", "-1", "-1", "-1", "-1", errors);
    }

    public static List<Error> getErrors(Exception output) {
        Error error = Error.create(null, output.getMessage(), output.getClass().getName());
        return Lists.newArrayList(error);
    }

    public static List<Error> getErrors(Throwable output) {
        ArrayList<Error> errors = Lists.newArrayList();
        String context = null;
        String message = output.getMessage();
        String[] messageParts = output.getMessage().split("->");
        switch (messageParts.length) {
            case 1: {
                message = messageParts[0].trim();
                break;
            }
            case 3: {
                context = messageParts[0].trim();
                message = messageParts[2].trim();
            }
        }
        Error error = Error.create(context, message, output.getClass().getCanonicalName());
        errors.add(error);
        return errors;
    }

    public static final class JENKINS_21311
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            try {
                if (throwable.getClass() == ResourceNotFoundException.class) {
                    return RequestStatus.create(true, null);
                }
                return RequestStatus.create(false, JenkinsFallbacks.getErrors(throwable));
            }
            catch (JsonSyntaxException e) {
                return RequestStatus.create(false, JenkinsFallbacks.getErrors(e));
            }
        }
    }

    public static final class PluginsOnError
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            try {
                return Plugins.create(null, null, JenkinsFallbacks.getErrors(throwable));
            }
            catch (JsonSyntaxException e) {
                return Plugins.create(null, null, JenkinsFallbacks.getErrors(e));
            }
        }
    }

    public static final class CrumbOnError
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            try {
                return Crumb.create(null, JenkinsFallbacks.getErrors(throwable));
            }
            catch (JsonSyntaxException e) {
                return Crumb.create(null, JenkinsFallbacks.getErrors(e));
            }
        }
    }

    public static final class IntegerResponseOnError
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            try {
                return IntegerResponse.create(null, JenkinsFallbacks.getErrors(throwable));
            }
            catch (JsonSyntaxException e) {
                return IntegerResponse.create(null, JenkinsFallbacks.getErrors(e));
            }
        }
    }

    public static final class RequestStatusOnError
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            try {
                return RequestStatus.create(false, JenkinsFallbacks.getErrors(throwable));
            }
            catch (JsonSyntaxException e) {
                return RequestStatus.create(false, JenkinsFallbacks.getErrors(e));
            }
        }
    }

    public static final class SystemInfoOnError
    implements Fallback<Object> {
        @Override
        public Object createOrPropagate(Throwable throwable) {
            Preconditions.checkNotNull(throwable, "throwable");
            return JenkinsFallbacks.createSystemInfoFromErrors(JenkinsFallbacks.getErrors(throwable));
        }
    }
}

