/*
 * Decompiled with CFR 0.152.
 */
package com.robot.logutils;

import android.content.ClipboardManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ToastUtils;
import com.robot.logutils.DebugApiAdapter;
import com.robot.logutils.LogDataUtils;
import com.robot.logutils.LogEntity;
import com.robot.logutils.R;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class LogRecordActivity
extends AppCompatActivity {
    private static final int SCROLL_DOWN_CODE = 1005;
    private long scrollTime;
    private RecyclerView rvDebugApi;
    private DebugApiAdapter debugApiAdapter;
    private final SimpleDateFormat debugApiDateFormat = new SimpleDateFormat("MM-dd hh:mm:ss.SSS");
    private Handler mMainHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1005: {
                    if (LogRecordActivity.this.debugApiAdapter == null || LogRecordActivity.this.debugApiAdapter.getData().size() <= 0) break;
                    LogRecordActivity.this.debugApiAdapter.notifyDataSetChanged();
                    List<LogEntity> list = LogRecordActivity.this.debugApiAdapter.getData();
                    synchronized (list) {
                        LogRecordActivity.this.rvDebugApi.scrollToPosition(LogRecordActivity.this.debugApiAdapter.getData().size() - 1);
                        break;
                    }
                }
            }
        }
    };
    public DebugApiAdapter.OnLongClickListener mOnLongClickListener = () -> {
        ArrayList<LogEntity> copyList;
        ClipboardManager cm = (ClipboardManager)this.getSystemService("clipboard");
        List<LogEntity> list = this.debugApiAdapter.getData();
        synchronized (list) {
            copyList = new ArrayList<LogEntity>(this.debugApiAdapter.getData());
        }
        cm.setText((CharSequence)copyList.toString());
        ToastUtils.showShort((CharSequence)"\u8c03\u8bd5\u4fe1\u606f\u5168\u90e8\u590d\u5236\u6210\u529f");
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log_record);
        this.rvDebugApi = (RecyclerView)this.findViewById(R.id.rv_debug_api);
        this.debugApiAdapter = new DebugApiAdapter(this.mOnLongClickListener);
        this.rvDebugApi.setAdapter((RecyclerView.Adapter)this.debugApiAdapter);
        this.debugApiAdapter.getData().addAll(LogDataUtils.getInstance().getData());
        this.debugApiAdapter.notifyDataSetChanged();
        this.scrollToBottom();
    }

    private void scrollToBottom() {
        this.mMainHandler.removeMessages(1005);
        if (System.currentTimeMillis() - this.scrollTime > 200L) {
            this.scrollTime = System.currentTimeMillis();
            this.mMainHandler.sendEmptyMessage(1005);
        } else {
            this.mMainHandler.sendEmptyMessageDelayed(1005, 200L);
        }
    }
}

