/*
 * Decompiled with CFR 0.152.
 */
package com.robot.logutils;

import com.blankj.utilcode.util.ActivityUtils;
import com.robot.logutils.LogEntity;
import com.robot.logutils.LogRecordActivity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class LogDataUtils {
    private static LogDataUtils instance = null;
    private final List<LogEntity> data;
    private final SimpleDateFormat debugApiDateFormat = new SimpleDateFormat("MM-dd hh:mm:ss.SSS");

    private LogDataUtils() {
        this.data = new ArrayList<LogEntity>();
    }

    public static void init() {
        if (instance == null) {
            instance = new LogDataUtils();
        }
    }

    public static LogDataUtils getInstance() {
        if (instance == null) {
            throw new IllegalArgumentException("please init LogDataUtils");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String type, String logMsg) {
        String msg = this.debugApiDateFormat.format(System.currentTimeMillis()) + "/" + type + "/:             " + logMsg;
        List<LogEntity> list = this.data;
        synchronized (list) {
            LogEntity logEntity = new LogEntity(type, msg.toCharArray());
            this.data.add(logEntity);
            if (this.data.size() > 10000) {
                this.data.remove(0);
            }
        }
    }

    public void toLogPage() {
        ActivityUtils.startActivity(LogRecordActivity.class);
    }

    public List<LogEntity> getData() {
        return this.data;
    }
}

