/*
 * Decompiled with CFR 0.152.
 */
package com.robot.logutils;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.StringUtils;
import com.robot.logutils.LogEntity;
import com.robot.logutils.R;
import java.util.ArrayList;
import java.util.List;

public class DebugApiAdapter
extends RecyclerView.Adapter<ViewHolder>
implements View.OnLongClickListener {
    private final List<LogEntity> data = new ArrayList<LogEntity>();
    private final OnLongClickListener mOnLongClickListener;

    public DebugApiAdapter(OnLongClickListener onLongClickListener) {
        this.mOnLongClickListener = onLongClickListener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_debug_api, parent, false);
        v.setOnLongClickListener((View.OnLongClickListener)this);
        return new ViewHolder(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        List<LogEntity> list = this.data;
        synchronized (list) {
            if (position < this.data.size()) {
                if (StringUtils.equals((CharSequence)this.data.get(position).getType(), (CharSequence)"v")) {
                    holder.mTv.setTextColor(Color.parseColor((String)"#ffffff"));
                    holder.mTv.setText(this.data.get(position).getData(), 0, this.data.get(position).getData().length);
                } else if (StringUtils.equals((CharSequence)this.data.get(position).getType(), (CharSequence)"d")) {
                    holder.mTv.setTextColor(Color.parseColor((String)"#ffffff"));
                    holder.mTv.setText(this.data.get(position).getData(), 0, this.data.get(position).getData().length);
                } else if (StringUtils.equals((CharSequence)this.data.get(position).getType(), (CharSequence)"i")) {
                    holder.mTv.setTextColor(Color.parseColor((String)"#ffffff"));
                    holder.mTv.setText(this.data.get(position).getData(), 0, this.data.get(position).getData().length);
                } else if (StringUtils.equals((CharSequence)this.data.get(position).getType(), (CharSequence)"w")) {
                    holder.mTv.setTextColor(Color.parseColor((String)"#00ff00"));
                    holder.mTv.setText(this.data.get(position).getData(), 0, this.data.get(position).getData().length);
                } else {
                    holder.mTv.setTextColor(Color.parseColor((String)"#00ff00"));
                    holder.mTv.setText(this.data.get(position).getData(), 0, this.data.get(position).getData().length);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        List<LogEntity> list = this.data;
        synchronized (list) {
            return this.data.size();
        }
    }

    public boolean onLongClick(View view) {
        this.mOnLongClickListener.onLongClick();
        return false;
    }

    public List<LogEntity> getData() {
        return this.data;
    }

    public static interface OnLongClickListener {
        public void onLongClick();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView mTv;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.mTv = (TextView)itemView.findViewById(R.id.tv_debug_api);
        }
    }
}

