/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test;

import io.ebean.DB;
import io.ebean.test.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;

public class DbJson {
    public static PrettyJson of(Object bean) {
        return new PrettyJson(DB.json().toJsonPretty(bean));
    }

    public static String readResource(String resourcePath) {
        InputStream is = DbJson.class.getResourceAsStream(resourcePath);
        try {
            return IOUtils.readUtf8(is).trim();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class PrettyJson {
        private String placeHolder = "\"*\"";
        private String rawJson;

        PrettyJson(String rawJson) {
            this.rawJson = rawJson;
        }

        public PrettyJson withPlaceholder(String placeHolder) {
            this.placeHolder = placeHolder;
            return this;
        }

        public PrettyJson replace(String ... propertyNames) {
            for (String propertyName : propertyNames) {
                String placeholder = "\"" + propertyName + "\": " + this.placeHolder;
                this.rawJson = this.rawJson.replaceAll("\"" + propertyName + "\": (\\d+)", placeholder);
                this.rawJson = this.rawJson.replaceAll("\"" + propertyName + "\": \"(.*?)\"", placeholder);
            }
            return this;
        }

        public String asJson() {
            return this.rawJson;
        }

        public void assertContentMatches(String resourcePath) {
            Assertions.assertThat((String)this.rawJson).isEqualTo(DbJson.readResource(resourcePath));
        }
    }
}

