/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.provider;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.ServerConfig;
import io.ebean.test.config.provider.FixedEncryptKeyManager;
import io.ebean.test.config.provider.WhoTenantProvider;
import io.ebean.test.config.provider.WhoUserProvider;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(ProviderAutoConfig.class);
    private final ServerConfig serverConfig;
    private final Properties properties;

    public ProviderAutoConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.properties = serverConfig.getProperties();
    }

    public void run() {
        EncryptKeyManager keyManager;
        CurrentTenantProvider tenantProvider;
        int providerSetFlag = 0;
        CurrentUserProvider provider = this.serverConfig.getCurrentUserProvider();
        if (provider == null) {
            providerSetFlag = 1;
            this.serverConfig.setCurrentUserProvider((CurrentUserProvider)new WhoUserProvider());
        }
        if ((tenantProvider = this.serverConfig.getCurrentTenantProvider()) == null) {
            providerSetFlag += 2;
            this.serverConfig.setCurrentTenantProvider((CurrentTenantProvider)new WhoTenantProvider());
        }
        if ((keyManager = this.serverConfig.getEncryptKeyManager()) == null) {
            String keyVal = this.properties.getProperty("ebean.test.encryptKey", "simple0123456789");
            log.debug("for testing - using FixedEncryptKeyManager() keyVal:{}", (Object)keyVal);
            this.serverConfig.setEncryptKeyManager((EncryptKeyManager)new FixedEncryptKeyManager(keyVal));
        }
        if (providerSetFlag > 0) {
            log.info(this.msg(providerSetFlag));
        }
    }

    String msg(int providerSetFlag) {
        String msg = this.msgProvider(providerSetFlag);
        String usage = this.msgUsage(providerSetFlag);
        return "for testing purposes " + msg + " has been configured. Use io.ebean.test.UserContext to " + usage + " in tests.";
    }

    private String msgProvider(int providerSetFlag) {
        switch (providerSetFlag) {
            case 1: {
                return "a current user provider";
            }
            case 2: {
                return "a current tenant provider";
            }
            case 3: {
                return "a current user and tenant provider";
            }
        }
        return "[unexpected??]";
    }

    private String msgUsage(int providerSetFlag) {
        switch (providerSetFlag) {
            case 1: {
                return "set current user";
            }
            case 2: {
                return "set current tenant";
            }
            case 3: {
                return "set current user and tenant";
            }
        }
        return "[unexpected??]";
    }
}

