/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.platform;

import io.ebean.docker.commands.ElasticConfig;
import io.ebean.docker.commands.ElasticContainer;
import java.util.Properties;

class ElasticSearchSetup {
    private static final String[] DOCKER_PARAMS = new String[]{"containerName", "image", "internalPort", "startMode", "shutdown"};
    private final Properties config;

    ElasticSearchSetup(Properties config) {
        this.config = config;
    }

    void run() {
        ElasticConfig elasticConfig = this.readConfig();
        if (elasticConfig != null) {
            new ElasticContainer(elasticConfig).start();
        }
    }

    ElasticConfig readConfig() {
        String version = this.read("version", null);
        if (version == null) {
            return null;
        }
        return new ElasticConfig(version, this.populateDockerProperties(version));
    }

    private Properties populateDockerProperties(String version) {
        PropertiesBuilder properties = new PropertiesBuilder();
        String mode = this.config.getProperty("ebean.test.shutdown");
        if (mode != null) {
            properties.set("shutdown", mode);
        }
        properties.set("version", version);
        properties.set("port", this.read("port", "9201"));
        for (String dockerParam : DOCKER_PARAMS) {
            String val = this.read(dockerParam, null);
            if (val == null) continue;
            properties.set(dockerParam, val);
        }
        return properties.build();
    }

    private String read(String key, String defaultValue) {
        return this.config.getProperty("ebean.docstore.elastic." + key, defaultValue);
    }

    private static class PropertiesBuilder {
        private Properties dockerProperties = new Properties();

        private PropertiesBuilder() {
        }

        private void set(String key, String val) {
            this.dockerProperties.setProperty("elastic." + key, val);
        }

        private Properties build() {
            return this.dockerProperties;
        }
    }
}

