/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BasePostgresContainer;
import io.ebean.docker.commands.DbConfig;
import java.util.ArrayList;

public class YugabyteContainer
extends BasePostgresContainer {
    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return YugabyteContainer.builder(version);
    }

    private YugabyteContainer(Builder builder) {
        super((DbConfig)builder);
    }

    @Override
    protected ProcessBuilder runProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.config.containerName());
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("-p");
        args.add("7000:7000");
        args.add("-p");
        args.add("9000:9000");
        args.add("-p");
        args.add("9042:9042");
        args.add(this.config.getImage());
        args.add("bin/yugabyted");
        args.add("start");
        args.add("--daemon=false");
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends DbConfig<YugabyteContainer, Builder> {
        private Builder(String version) {
            super("yugabyte", 6433, 5433, version);
            this.image = "yugabytedb/yugabyte:" + version;
            this.adminUsername = "postgres";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/postgres";
        }

        @Override
        public YugabyteContainer build() {
            return new YugabyteContainer(this);
        }
    }
}

