/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.BaseContainer;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;

public class RedisContainer
extends BaseContainer {
    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return RedisContainer.builder(version);
    }

    private RedisContainer(Builder builder) {
        super(builder);
    }

    @Override
    boolean checkConnectivity() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.indexOf("win") > -1) {
            return this.doWindowsCheck();
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("nc", this.config.getHost(), Integer.toString(this.config.getPort()), "-q", "0");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            OutputStreamWriter ow = new OutputStreamWriter(process.getOutputStream());
            ow.write("PING");
            ow.flush();
            ow.close();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean doWindowsCheck() {
        try {
            Thread.sleep(20L);
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add(this.config.image());
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends BaseConfig<RedisContainer, Builder> {
        private Builder(String version) {
            super("redis", 6379, 6379, version);
        }

        @Override
        public RedisContainer build() {
            return new RedisContainer(this);
        }
    }
}

