/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

abstract class MySqlBaseContainer
extends JdbcBaseDbContainer
implements Container {
    MySqlBaseContainer(DbConfig<?, ?> config) {
        super(config);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropUserIfExists(connection, this.dbConfig.getUsername());
                this.dropDatabaseIfExists(connection, this.dbConfig.getDbName());
            }
            this.createDatabase(connection);
            this.createUser(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void createUser(Connection connection) {
        this.createUser(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword(), this.dbConfig.getDbName());
    }

    private void dropDatabaseIfExists(Connection connection, String dbName) {
        if (this.databaseExists(connection, dbName)) {
            this.sqlRun(connection, "drop database " + dbName);
        }
    }

    private void dropUserIfExists(Connection connection, String username) {
        if (this.userExists(connection, username)) {
            this.sqlRun(connection, "drop user '" + username + "'@'%'");
        }
    }

    private void createUser(Connection connection, String dbUser, String dbPassword, String db) {
        if (!this.userExists(connection, dbUser)) {
            this.sqlRun(connection, "create user '" + dbUser + "'@'%' identified by '" + dbPassword + "'");
            this.sqlRun(connection, "grant all on " + db + ".* to '" + dbUser + "'@'%'");
        }
    }

    private void createDatabase(Connection connection) {
        if (!this.databaseExists(connection, this.dbConfig.getDbName())) {
            this.createDatabase(connection, this.dbConfig.getDbName());
            if (!this.dbConfig.version().startsWith("5")) {
                this.setLogBinTrustFunction(connection);
            }
        }
    }

    private void setLogBinTrustFunction(Connection connection) {
        this.sqlRun(connection, "set global log_bin_trust_function_creators=1");
    }

    private void createDatabase(Connection connection, String dbName) {
        this.sqlRun(connection, "create database " + dbName);
    }

    private boolean databaseExists(Connection connection, String dbName) {
        return this.sqlHasRow(connection, "show databases like '" + dbName + "'");
    }

    private boolean userExists(Connection connection, String dbUser) {
        return this.sqlHasRow(connection, "select User from user where User = '" + dbUser + "'");
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        if (this.defined(this.dbConfig.getAdminPassword())) {
            args.add("-e");
            args.add("MYSQL_ROOT_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add(this.config.getImage());
        if (!this.dbConfig.isDefaultCollation()) {
            if (this.dbConfig.isExplicitCollation()) {
                String collation;
                String characterSet = this.dbConfig.getCharacterSet();
                if (characterSet != null) {
                    args.add("--character-set-server=" + characterSet);
                }
                if ((collation = this.dbConfig.getCollation()) != null) {
                    args.add("--collation-server=" + collation);
                }
            } else {
                args.add("--character-set-server=utf8mb4");
                args.add("--collation-server=utf8mb4_bin");
            }
        }
        if (!this.dbConfig.version().startsWith("5")) {
            args.add("--default-authentication-plugin=mysql_native_password");
            args.add("--skip-log-bin");
        }
        return this.createProcessBuilder(args);
    }
}

