/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.MySqlBaseContainer;

public class MariaDBContainer
extends MySqlBaseContainer {
    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return MariaDBContainer.builder(version);
    }

    private MariaDBContainer(Builder builder) {
        super(builder);
    }

    public static class Builder
    extends DbConfig<MariaDBContainer, Builder> {
        private Builder(String version) {
            super("mariadb", 4306, 3306, version);
            this.adminUsername = "root";
            this.adminPassword = "admin";
            this.tmpfs = "/var/lib/mysql:rw";
        }

        protected Builder(String platform, int port, int internalPort, String version) {
            super(platform, port, internalPort, version);
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:mysql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:mysql://" + this.getHost() + ":" + this.getPort() + "/mysql";
        }

        @Override
        public MariaDBContainer build() {
            return new MariaDBContainer(this);
        }
    }
}

