/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseConfig;
import io.ebean.docker.commands.BaseContainer;
import java.io.IOException;
import java.util.List;

public class ElasticContainer
extends BaseContainer {
    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return ElasticContainer.builder(version);
    }

    private ElasticContainer(Builder builder) {
        super(builder);
    }

    public String endpointUrl() {
        return String.format("http://%s:%s/", this.config.getHost(), this.config.getPort());
    }

    @Override
    boolean checkConnectivity() {
        try {
            return this.readUrlContent(this.endpointUrl()).contains("docker-cluster");
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-e");
        args.add("http.host=0.0.0.0");
        args.add("-e");
        args.add("transport.host=127.0.0.1");
        args.add("-e");
        args.add("xpack.security.enabled=false");
        args.add(this.config.image());
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends BaseConfig<ElasticContainer, Builder> {
        private Builder(String version) {
            super("elastic", 9201, 9200, version);
            this.image = "docker.elastic.co/elasticsearch/elasticsearch:" + version;
        }

        @Override
        public ElasticContainer build() {
            return new ElasticContainer(this);
        }
    }
}

