/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import java.io.File;
import java.util.Locale;

public class DockerHost {
    private static final String HOST = new DockerHost().dockerHost;
    private final boolean runningInDocker = this.initInDocker();
    private final String dockerHost = this.initDockerHost();

    DockerHost() {
    }

    public static String host() {
        return HOST;
    }

    boolean runningInDocker() {
        return this.runningInDocker;
    }

    String dockerHost() {
        return this.dockerHost;
    }

    String initDockerHost() {
        return !this.runningInDocker ? "localhost" : this.dockerInDockerHost();
    }

    boolean initInDocker() {
        return new File("/.dockerenv").exists();
    }

    String dockerInDockerHost() {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin") || os.contains("win")) {
            return "host.docker.internal";
        }
        return "172.17.0.1";
    }
}

