/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DockerHost;
import io.ebean.docker.commands.InternalConfig;
import io.ebean.docker.container.ContainerBuilder;
import io.ebean.docker.container.StartMode;
import io.ebean.docker.container.StopMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

abstract class BaseConfig<C, SELF extends BaseConfig<C, SELF>>
implements ContainerBuilder<C, SELF> {
    protected final String platform;
    protected String containerName;
    protected String host = DockerHost.host();
    protected int port;
    protected int internalPort;
    protected int adminPort;
    protected int adminInternalPort;
    protected String image;
    protected StartMode startMode = StartMode.Create;
    protected StopMode shutdownMode = StopMode.Auto;
    protected int maxReadyAttempts = 300;
    protected String docker = "docker";
    protected final String version;

    BaseConfig(String platform, int port, int internalPort, String version) {
        this.platform = platform;
        this.port = port;
        this.internalPort = internalPort;
        this.image = platform + ":" + version;
        this.version = version;
    }

    protected String docker() {
        return this.docker;
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    protected SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF startMode(StartMode startMode) {
        this.startMode = startMode;
        return this.self();
    }

    @Override
    public SELF shutdownMode(StopMode shutdownMode) {
        this.shutdownMode = shutdownMode;
        return this.self();
    }

    @Override
    public SELF properties(Properties properties) {
        if (properties == null) {
            return this.self();
        }
        this.docker = properties.getProperty("docker", this.docker);
        this.containerName = this.prop(properties, "containerName", this.containerName);
        this.image = this.prop(properties, "image", this.image);
        this.host = this.prop(properties, "host", this.host);
        this.port = this.prop(properties, "port", this.port);
        this.internalPort = this.prop(properties, "internalPort", this.internalPort);
        this.adminPort = this.prop(properties, "adminPort", this.adminPort);
        this.adminInternalPort = this.prop(properties, "adminInternalPort", this.adminInternalPort);
        String start = properties.getProperty("startMode", this.startMode.name());
        this.startMode = StartMode.of(this.prop(properties, "startMode", start));
        String shutdown = properties.getProperty("shutdownMode", this.shutdownMode.name());
        this.shutdownMode = StopMode.of(this.prop(properties, "shutdownMode", shutdown));
        String maxVal = this.prop(properties, "maxReadyAttempts", null);
        if (maxVal != null) {
            try {
                this.maxReadyAttempts = Integer.parseInt(maxVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.extraProperties(properties);
        return this.self();
    }

    protected void extraProperties(Properties properties) {
    }

    protected String prop(Properties properties, String key, String defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
        return properties.getProperty(this.platform + "." + key, val);
    }

    protected int prop(Properties properties, String key, int defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key);
        val = properties.getProperty(this.platform + "." + key, val);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    @Override
    public SELF containerName(String containerName) {
        this.containerName = containerName;
        return this.self();
    }

    @Override
    public SELF port(int port) {
        this.port = port;
        return this.self();
    }

    @Override
    public SELF internalPort(int internalPort) {
        this.internalPort = internalPort;
        return this.self();
    }

    @Override
    public SELF adminPort(int adminPort) {
        this.adminPort = adminPort;
        return this.self();
    }

    @Override
    public SELF adminInternalPort(int adminInternalPort) {
        this.adminInternalPort = adminInternalPort;
        return this.self();
    }

    @Override
    public SELF image(String image) {
        this.image = image;
        return this.self();
    }

    @Override
    public SELF maxReadyAttempts(int maxReadyAttempts) {
        this.maxReadyAttempts = maxReadyAttempts;
        return this.self();
    }

    @Override
    public SELF docker(String docker) {
        this.docker = docker;
        return this.self();
    }

    protected InternalConfig internalConfig() {
        return new Inner();
    }

    protected String buildJdbcUrl() {
        throw new IllegalStateException("Not valid for this type");
    }

    protected String buildJdbcAdminUrl() {
        return this.buildJdbcUrl();
    }

    protected class Inner
    implements InternalConfig {
        protected Inner() {
        }

        @Override
        public void setDefaultContainerName() {
            if (BaseConfig.this.containerName == null && BaseConfig.this.port != 0) {
                BaseConfig.this.containerName = "ut_" + BaseConfig.this.platform;
            }
        }

        @Override
        public void setContainerId(String containerId) {
            BaseConfig.this.containerName = containerId;
        }

        @Override
        public void setAssignedPort(int assignedPort) {
            BaseConfig.this.port = assignedPort;
        }

        @Override
        public Connection createConnection() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createConnectionNoSchema() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createAdminConnection() throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public Connection createAdminConnection(String url) throws SQLException {
            throw new IllegalStateException("Not valid for this type");
        }

        @Override
        public int port() {
            return this.getPort();
        }

        @Override
        public String jdbcUrl() {
            return BaseConfig.this.buildJdbcUrl();
        }

        @Override
        public String jdbcAdminUrl() {
            return BaseConfig.this.buildJdbcAdminUrl();
        }

        @Override
        public String startDescription() {
            return "starting " + BaseConfig.this.platform + " container:" + BaseConfig.this.containerName + " port:" + BaseConfig.this.port + " startMode:" + (Object)((Object)BaseConfig.this.startMode);
        }

        @Override
        public String stopDescription() {
            return "stopping " + BaseConfig.this.platform + " container:" + BaseConfig.this.containerName;
        }

        @Override
        public String platform() {
            return BaseConfig.this.platform;
        }

        @Override
        public String containerName() {
            return BaseConfig.this.containerName;
        }

        @Override
        public String version() {
            return BaseConfig.this.version;
        }

        @Override
        public String getHost() {
            return BaseConfig.this.host;
        }

        @Override
        public int getPort() {
            return BaseConfig.this.port;
        }

        @Override
        public boolean randomPort() {
            return BaseConfig.this.port == 0;
        }

        @Override
        public int getInternalPort() {
            return BaseConfig.this.internalPort;
        }

        @Override
        public int getAdminPort() {
            return BaseConfig.this.adminPort;
        }

        @Override
        public int getAdminInternalPort() {
            return BaseConfig.this.adminInternalPort;
        }

        @Override
        public String getImage() {
            return BaseConfig.this.image;
        }

        @Override
        public StartMode getStartMode() {
            return BaseConfig.this.startMode;
        }

        @Override
        public int getMaxReadyAttempts() {
            return BaseConfig.this.maxReadyAttempts;
        }

        @Override
        public String getDocker() {
            return BaseConfig.this.docker;
        }

        @Override
        public StopMode shutdownMode() {
            return BaseConfig.this.shutdownMode;
        }

        @Override
        public String docker() {
            return BaseConfig.this.docker;
        }

        @Override
        public String image() {
            return BaseConfig.this.image;
        }
    }
}

