/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseContainer;
import io.ebean.docker.commands.CommandException;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.container.Container;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

abstract class DbContainer
extends BaseContainer
implements Container {
    final DbConfig dbConfig;
    boolean checkConnectivityUsingAdmin;
    int conditionPauseMillis = 100;

    DbContainer(DbConfig config) {
        super(config);
        this.dbConfig = config;
    }

    @Override
    void logRunning() {
        log.info("Container {} running with {} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.logShutdown()});
    }

    @Override
    void logRun() {
        log.info("Run container {} with {} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.logShutdown()});
    }

    @Override
    void logStart() {
        log.info("Start container {} with {} shutdown:{}", new Object[]{this.config.containerName(), this.dbConfig.summary(), this.logShutdown()});
    }

    private String logShutdown() {
        return this.dbConfig.shutdownMode == null ? "" : this.dbConfig.shutdownMode.name();
    }

    public String jdbcUrl() {
        return this.config.jdbcUrl();
    }

    public Connection createConnection() throws SQLException {
        return this.config.createConnection();
    }

    @Override
    public boolean start() {
        return this.shutdownHook(this.logStarted(this.startForMode()));
    }

    protected boolean startForMode() {
        switch (this.config.getStartMode()) {
            case DropCreate: {
                return this.startWithDropCreate();
            }
            case Container: {
                return this.startContainerOnly();
            }
        }
        return this.startWithCreate();
    }

    public boolean startWithCreate() {
        return this.startWithConnectivity();
    }

    public boolean startWithDropCreate() {
        return this.startWithConnectivity();
    }

    public boolean startContainerOnly() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity for {}", (Object)this.config.containerName());
            return false;
        }
        return true;
    }

    protected boolean fastStart() {
        if (!this.dbConfig.isFastStartMode()) {
            return false;
        }
        try {
            return this.isFastStartDatabaseExists();
        }
        catch (CommandException e) {
            log.debug("failed fast start check - using normal startup");
            return false;
        }
    }

    protected boolean isFastStartDatabaseExists() {
        return false;
    }

    @Override
    protected abstract ProcessBuilder runProcess();

    protected abstract boolean isDatabaseReady();

    protected abstract boolean isDatabaseAdminReady();

    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        throw new RuntimeException("executeSqlFile is Not implemented for this platform - Postgres only at this stage");
    }

    public boolean waitForDatabaseReady() {
        return this.conditionLoop(this::isDatabaseReady) && this.conditionLoop(this::isDatabaseAdminReady);
    }

    private boolean conditionLoop(BooleanSupplier condition) {
        for (int i = 0; i < this.config.getMaxReadyAttempts(); ++i) {
            try {
                if (condition.getAsBoolean()) {
                    return true;
                }
                this.pause();
                continue;
            }
            catch (CommandException e) {
                this.pause();
            }
        }
        return false;
    }

    private void pause() {
        try {
            Thread.sleep(this.conditionPauseMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    boolean checkConnectivity() {
        return this.checkConnectivity(this.checkConnectivityUsingAdmin);
    }

    boolean checkConnectivity(boolean useAdmin) {
        try {
            log.trace("checkConnectivity on {} ... ", (Object)this.config.containerName);
            try (Connection connection = useAdmin ? this.config.createAdminConnection() : this.config.createConnectionNoSchema();){
                log.debug("connectivity confirmed for {}", (Object)this.config.containerName);
            }
            return true;
        }
        catch (Throwable e) {
            log.trace("connection failed: " + e.getMessage());
            return false;
        }
    }

    boolean defined(String val) {
        return val != null && !val.trim().isEmpty();
    }

    void runDbSqlFile(String dbName, String dbUser, String sqlFile) {
        File file;
        if (this.defined(sqlFile) && (file = this.getResourceOrFile(sqlFile)) != null) {
            this.runSqlFile(file, dbUser, dbName);
        }
    }

    void runSqlFile(File file, String dbUser, String dbName) {
        if (this.copyFileToContainer(file)) {
            String containerFilePath = "/tmp/" + file.getName();
            this.executeSqlFile(dbUser, dbName, containerFilePath);
        }
    }

    File getResourceOrFile(String sqlFile) {
        File file = new File(sqlFile);
        if (!file.exists()) {
            file = this.checkFileResource(sqlFile);
        }
        if (file == null) {
            log.error("Could not find SQL file. No file exists at location or resource path for: " + sqlFile);
        }
        return file;
    }

    private File checkFileResource(String sqlFile) {
        try {
            File file;
            URL resource;
            if (!sqlFile.startsWith("/")) {
                sqlFile = "/" + sqlFile;
            }
            if ((resource = this.getClass().getResource(sqlFile)) != null && (file = Paths.get(resource.toURI()).toFile()).exists()) {
                return file;
            }
        }
        catch (Exception e) {
            log.error("Failed to obtain File from resource for init SQL file: " + sqlFile, (Throwable)e);
        }
        return null;
    }

    boolean copyFileToContainer(File sourceFile) {
        ProcessBuilder pb = this.copyFileToContainerProcess(sourceFile);
        return this.execute(pb, "Failed to copy file " + sourceFile.getAbsolutePath() + " to container");
    }

    private ProcessBuilder copyFileToContainerProcess(File sourceFile) {
        String dest = this.config.containerName() + ":/tmp/" + sourceFile.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("cp");
        args.add(sourceFile.getAbsolutePath());
        args.add(dest);
        return this.createProcessBuilder(args);
    }

    boolean execute(String expectedLine, ProcessBuilder pb) {
        return this.execute(expectedLine, pb, null);
    }

    boolean execute(String expectedLine, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!this.stdoutContains(outLines, expectedLine)) {
            if (errorMessage != null) {
                log.error(errorMessage + " stdOut:" + outLines + " Expected message:" + expectedLine);
            }
            return false;
        }
        return true;
    }

    boolean executeWithout(String errorMatch, ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (this.stdoutContains(outLines, errorMatch)) {
            log.error(errorMessage + " stdOut:" + outLines);
            return false;
        }
        return true;
    }

    boolean stdoutContains(List<String> outLines, String expectedLine) {
        for (String outLine : outLines) {
            if (!outLine.contains(expectedLine)) continue;
            return true;
        }
        return false;
    }

    boolean execute(ProcessBuilder pb, String errorMessage) {
        List<String> outLines = ProcessHandler.process(pb).getOutLines();
        if (!outLines.isEmpty()) {
            log.error(errorMessage + " stdOut:" + outLines);
            return false;
        }
        return true;
    }

    void sqlProcess(Consumer<Connection> runner) {
        try (Connection connection = this.config.createAdminConnection();){
            runner.accept(connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
    }

    void sqlRun(Connection connection, String sql) {
        log.debug("sqlRun: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean sqlHasRow(Connection connection, String sql) {
        log.trace("sqlRun: {}", (Object)sql);
        try (Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery(sql);){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to execute sql", e);
        }
    }

    boolean sqlQueryMatch(Connection connection, String sql, String match) throws SQLException {
        log.trace("sqlRun: {}", (Object)sql);
        try (PreparedStatement stmt = connection.prepareStatement(sql);
             ResultSet resultSet = stmt.executeQuery();){
            if (resultSet.next()) {
                boolean bl = resultSet.getString(1).equalsIgnoreCase(match);
                return bl;
            }
        }
        return false;
    }
}

