/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.BaseConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public abstract class DbConfig
extends BaseConfig {
    private String tmpfs;
    String adminUsername = "admin";
    String adminPassword = "admin";
    private String extraDb;
    private String extraDbUser;
    private String extraDbPassword;
    private String extraDbInitSqlFile;
    private String extraDbSeedSqlFile;
    String dbName = "test_db";
    String username = "test_user";
    String password = "test";
    String schema;
    private String extensions;
    private String initSqlFile;
    private String seedSqlFile;
    private boolean inMemory;
    boolean fastStartMode = true;

    DbConfig(String platform, int port, int internalPort, String version) {
        super(platform, port, internalPort, version);
    }

    @Override
    public String startDescription() {
        return "starting " + this.platform + " container:" + this.containerName + " port:" + this.port + " db:" + this.dbName + " user:" + this.username + " extensions:" + this.extensions + " startMode:" + (Object)((Object)this.startMode);
    }

    public String summary() {
        return "host:" + this.host + " port:" + this.port + " db:" + this.dbName + " user:" + this.username + "/" + this.password;
    }

    public void initDefaultSchema() {
        if (this.schema == null) {
            this.schema = this.username;
        }
    }

    @Override
    public Connection createConnection() throws SQLException {
        Properties props = new Properties();
        props.put("user", this.username);
        props.put("password", this.password);
        if (this.schema != null) {
            props.put("schema", this.schema);
        }
        return DriverManager.getConnection(this.jdbcUrl(), props);
    }

    @Override
    public Connection createConnectionNoSchema() throws SQLException {
        Properties props = new Properties();
        props.put("user", this.username);
        props.put("password", this.password);
        return DriverManager.getConnection(this.jdbcUrl(), props);
    }

    public Connection createAdminConnection(String url) throws SQLException {
        Properties props = new Properties();
        props.put("user", this.adminUsername);
        props.put("password", this.adminPassword);
        return DriverManager.getConnection(url, props);
    }

    @Override
    public Connection createAdminConnection() throws SQLException {
        return this.createAdminConnection(this.jdbcAdminUrl());
    }

    @Override
    public DbConfig setProperties(Properties properties) {
        if (properties == null) {
            return this;
        }
        super.setProperties(properties);
        this.inMemory = Boolean.parseBoolean(this.prop(properties, "inMemory", Boolean.toString(this.inMemory)));
        this.fastStartMode = Boolean.parseBoolean(this.prop(properties, "fastStartMode", Boolean.toString(this.fastStartMode)));
        this.tmpfs = this.prop(properties, "tmpfs", this.tmpfs);
        this.dbName = this.prop(properties, "dbName", this.dbName);
        this.username = this.prop(properties, "username", this.username);
        this.password = this.prop(properties, "password", this.password);
        this.schema = this.prop(properties, "schema", this.schema);
        this.extensions = this.prop(properties, "extensions", this.extensions);
        this.adminUsername = this.prop(properties, "adminUsername", this.adminUsername);
        this.adminPassword = this.prop(properties, "adminPassword", this.adminPassword);
        this.initSqlFile = this.prop(properties, "initSqlFile", this.initSqlFile);
        this.seedSqlFile = this.prop(properties, "seedSqlFile", this.seedSqlFile);
        this.extraDb = this.prop(properties, "extraDb.dbName", this.prop(properties, "extraDb", this.extraDb));
        this.extraDbUser = this.prop(properties, "extraDb.username", this.extraDbUser);
        this.extraDbPassword = this.prop(properties, "extraDb.password", this.extraDbPassword);
        this.extraDbInitSqlFile = this.prop(properties, "extraDb.initSqlFile", this.extraDbInitSqlFile);
        this.extraDbSeedSqlFile = this.prop(properties, "extraDb.seedSqlFile", this.extraDbSeedSqlFile);
        return this;
    }

    public DbConfig setAdminUser(String dbAdminUser) {
        this.adminUsername = dbAdminUser;
        return this;
    }

    public DbConfig setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public DbConfig setTmpfs(String tmpfs) {
        this.tmpfs = tmpfs;
        return this;
    }

    public DbConfig setFastStartMode(boolean fastStartMode) {
        this.fastStartMode = fastStartMode;
        return this;
    }

    public DbConfig setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public DbConfig setUser(String user) {
        this.username = user;
        return this;
    }

    public DbConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public DbConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public DbConfig setExtensions(String extensions) {
        this.extensions = extensions;
        return this;
    }

    public DbConfig setInitSqlFile(String initSqlFile) {
        this.initSqlFile = initSqlFile;
        return this;
    }

    public DbConfig setSeedSqlFile(String seedSqlFile) {
        this.seedSqlFile = seedSqlFile;
        return this;
    }

    public DbConfig setExtraDb(String extraDb) {
        this.extraDb = extraDb;
        return this;
    }

    public DbConfig setExtraDbUser(String extraDbUser) {
        this.extraDbUser = extraDbUser;
        return this;
    }

    public DbConfig setExtraDbPassword(String extraDbPassword) {
        this.extraDbPassword = extraDbPassword;
        return this;
    }

    public DbConfig setExtraDbInitSqlFile(String extraDbInitSqlFile) {
        this.extraDbInitSqlFile = extraDbInitSqlFile;
        return this;
    }

    public DbConfig setExtraDbSeedSqlFile(String extraDbSeedSqlFile) {
        this.extraDbSeedSqlFile = extraDbSeedSqlFile;
        return this;
    }

    public DbConfig setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
        return this;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public String getTmpfs() {
        return this.tmpfs;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getInitSqlFile() {
        return this.initSqlFile;
    }

    public String getSeedSqlFile() {
        return this.seedSqlFile;
    }

    public String getExtraDb() {
        return this.extraDb;
    }

    public String getExtraDbUser() {
        return this.extraDbUser;
    }

    public String getExtraDbPassword() {
        return this.extraDbPassword;
    }

    public String getExtraDbInitSqlFile() {
        return this.extraDbInitSqlFile;
    }

    public String getExtraDbSeedSqlFile() {
        return this.extraDbSeedSqlFile;
    }

    public boolean isFastStartMode() {
        return this.fastStartMode;
    }
}

